TITLE	LE_MCLK.ASM	3-27-86

;3-27-86 version corrects for bug in date function

;This software may be freely ditributed and no charge shall
;be made by anyone for its use or distribution except for
;a copying charge.

;This program reads the Leading Edge Model-M battery backed-up
;clock and sets the DOS clock to its values.  Put this in your
;AUTOEXEC.BAT file so that the DOS clock will show the date/time
;upon boot up when using DOS 3.x.  Works for Sperry PC also.

;					-Done by Bob Plouffe 
;					CompuServe: 70220,113
;					Fido: Net 109, node 404
;					PLOUFF at MIT-MC.ARPA
;					GENIE: RPLOUFFE
;
;*****************************************************************

;This short program uses an undocumented feature of the Leading Edge
;ROM Bios.  The Time-of Day interrupt (INT 1AH) has four additional
;functions beyond that of the IBMPC ROM Bios.  (See the IBM code for
;INT 1AH in the Technical Reference Manual.  Note that this function
;allows the current clock [DOS clock] to be set/read for AH=1/0 upon
;entry)  For the Leading Edge, Model M, this interrupt can also 
;set/read the date/time of the on-board battery backed-up clock. Entry
;and return of CX/DX registers is the same as for the DOS function
;calls with INT 21H for AH=2AH through 2DH except that CX sets/returns
;an offset from the year 1980 (07cbh).  The following AH reg entry
;values accomplish the described functions:

;		AH=2	Read the time from the battery backed-up clock.
;		AH=3	Set the time into the     "	 "         "
;		AH=4	Read the date from the	  "      "         "		
;		AH=5	Set the date into the     "      "         "

;*********************************************************************

;makes a .COM program.  Use EXE2BIN after assembling and linking.
 
;equates
;INT 21H Dos functions 
	set_cdate	equ	2b00h	;sets date in current clk
	set_ctime	equ	2d00h	;sets time in current clock
;INT 1AH Rom Bios functions
	get_btime	equ	0200h	;gets time from battery clk
	get_bdate	equ	0400h	;gets date from battery clk

;********************************************************************
;
le_mclk	segment

	assume ds:le_mclk, ss:le_mclk ,cs:le_mclk ,es:le_mclk

	org	100h

begin:	;read the time from the battery backed-up clock
rdtime:	mov	ax,get_btime	;to read time (battery clock)
	int	1ah		;returns time in CX and DX
	;now set the current clock time
	mov	ax,set_ctime	;set time in timer chip
	int	21h		;
	;
	;read the date from the battery backed-up clock
rddate:	mov	ax,get_bdate	;to read date (battery clock)
	int	1ah		;returns date in CX and DX
	;now set the date for the current clock
	mov	ch,0		;clear CH
	add	cx,07bch	;add 1980 to the year offset in CX
	mov	ax,set_cdate	;set date in current clock
	int	21h		;
	;	
done:	int	20h		;we are done, so return to DOS
	le_mclk	ends
;
end begin
