/* File......: WHEREIS.PRG
 * Author....: Steve Larsen
 * CIS ID....: 76370,1532
 * Date......: $Date:   15 Aug 1991 23:06:38  $
 * Revision..: $Revision:   1.0  $
 * Log file..: $Logfile:   E:/nanfor/src/whereis.prv  $
 *
 * This is an original work by K. Stephan Larsen and is placed in
 * the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   E:/nanfor/src/whereis.prv  $
 * 
 *    Rev 1.0   15 Aug 1991 23:06:38   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 *
 *     Rev 1.0   07 Jun 1991 21:56:10   GLENN
 *  Initial revision.
 *
 */

/* $DOC$
 * $FUNCNAME$
 *    FT_WHEREIS()
 * $CATEGORY$
 *    Environment
 * $ONELINER$
 *    Locate all occurrences of a filespec on a drive
 * $SYNTAX$
 *    FT_WHEREIS( [ <cDrive:> ][ <cFilespec> ] ) -> aFiles
 * $ARGUMENTS$
 *    <cDrive:> is an optional drive to search.  If omitted, FT_WHEREIS()
 *    defaults to the current drive.
 *
 *    <cFilespec> is a DOS legal filespec containing the pattern that
 *    you want found.  The wildcard characters "*" and "?" are supported.
 *    If no <cFilespec> is specified, FT_WHEREIS() defaults to all files.
 * $RETURNS$
 *    An array of filenames that match <cFilespec>.
 * $DESCRIPTION$
 *    Use FT_WHEREIS() to obtain an array with the full path/filenames of all
 *    files on the specified or current drive that match a DOS legal filespec.
 *
 *    You may optionally specify a drive to search, other than the current
 *    drive.  Please note that FT_WHEREIS() will not cause a runtime error if
 *    you specify an invalid or inoperable drive; it instead returns an
 *    empty array.
 * $EXAMPLES$
 *    /* Example 1 */
 *    aComSpec := FT_WHEREIS( "command.com" ) // aComSpec now contains an
 *                                            // entry for every "Command.com"
 *                                            // on the current drive
 *    /* Example 2 */
 *    aBat := FT_WHEREIS( "a:*.bat" )
 *
 *    IF Empty( aBat )
 *       ?"Please make sure the proper diskette is in drive A:, and that"
 *       ?"the drive door is closed."
 *    ELSE
 *       ? "You have " + Len( aBat ) " batch files on drive A:"
 *    ENDIF
 * $INCLUDE$
 * $SEEALSO$
 *    FT_TREE() FT_ORIGIN()
 * $END$
 */

FUNCTION FT_WHEREIS( cFilespec )

LOCAL nFilecount, aFiles := {}

IF ( nFilecount := __ft_where( cFilespec ) ) > 0
   __ft_where( cFilespec, aFiles := Array( nFilecount ) )
ENDIF

RETURN aFiles


/* $DOC$
 * $FUNCNAME$
 *    FT_TREE()
 * $CATEGORY$
 *    Environment
 * $ONELINER$
 *    Locate all directories and subdirectories on a drive
 * $SYNTAX$
 *    FT_TREE( [ <cDrive:> ] ) -> aDirectories
 * $ARGUMENTS$
 *    <cDrive:> is an optional drive to search.  If omitted, FT_TREE()
 *    defaults to the current drive.
 * $RETURNS$
 *    An array containing the name of each directory found on the specified
 *    drive.
 * $DESCRIPTION$
 *    Use FT_TREE() to obtain an array of the directory structure of a
 *    specified drive.
 *
 *    You may optionally specify a drive to search, other than the current
 *    drive.  Please note that FT_TREE() will not cause a runtime error if
 *    you specify an invalid or inoperable drive, instead returns an
 *    empty array.
 *
 *    The directory structure returned is not ordered in any way other than
 *    the order that the directories are contained in DOS.  To put the
 *    directories in alphabetical order, use ASORT().
 * $EXAMPLES$
 *    // list all directories on the current drive
 *    aTree := FT_TREE()
 *    Aeval( aTree, {|e| Qout(e) } )
 * $INCLUDE$
 * $SEEALSO$
 *    FT_WHEREIS() FT_ORIGIN()
 * $END$
 */

FUNCTION FT_TREE( cDrive )

LOCAL nDircount, aDirs := {}

IF ( nDircount := __ft_tree( cDrive ) ) > 0
   __ft_tree( cDrive, aDirs := Array( nDircount ) )
ENDIF

RETURN aDirs

