
/*============================================================================

	IMAGHEAD.H
	C-version of IMAGHEAD.INC.
  This file is part of the

  PseudoCD package (version 02)
  Copyright (C) C.Kulms, 1997

  This is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this software; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

============================================================================*/

/*
	THIS IS THE C-VERSION OF THE FILE 'IMAGHEAD.INC' - ENSURE THAT THEY ARE
	CONSISTENT!
*/

#ifndef _IMAGEHEAD_H_
#define _IMAGEHEAD_H_
#ifndef _CDROM_H_
	#include "cdrom.h"
#endif

/* sector-sizes */
#define BPHDS		512			/* bytes per hd-sector */
#define BPHDSsh	9				/* -"- as shift value */
#define BPHDSmk	0x0FE00	/* mask for offset in hd-sector */
#define BPCDS		2048		/* bytes per cd-sector (cooked) */
#define BPCDSsh	11			/* -"- as shift value */
#define BPCDRAW	2352		/* bytes per cd-sector (raw-mode) */
#define SPCDS		4				/* hd-sectors per (cooked) cd-sector */
#define SPCDSsh	2				/* -"- as shift value */

#define SIGNATURE	"PSEUDOCD-IMAGE header version 01"	/* signature of image */
#define SIGNLEN	32					/* may. length of signature */
#define IMGCOMSIZE	78			/* max. size of comment */

/*
	t_TRACKINFO is typedef'ed in file 'cdrom.h'
*/

typedef struct s_IMAGEHEADER
{
	/* data of cdrom */
	unsigned char		ucLowTrack;		/* lowest track number (binary) */
  unsigned char		ucHighTrack;	/* highest track number (binary) */
	unsigned long		ulVolSize;		/* volume size */
	t_REDBOOK				tLeadOut;			/* address of lead-out track */
	unsigned long		ulTotBytes;		/* size in bytes (cooked) */
	unsigned long		ulTotSize;		/* total cd-size in cd-sectors */
	unsigned long		ulTotHdSecs;	/* total size in hd-sectors (=TotSize*SPCDS) */
	t_TRACKINFO			tTrackInfo[99];

	/* data used by driver to identify valid image */
	char						acSignature[SIGNLEN];

	/* user's comment */
  char		acImgComment[IMGCOMSIZE+1]; /* terminate with '$' */
}	t_IMAGEHEADER;

/* number of HD-sectors to reserve for the header */
#define HEADERHDSECS	((sizeof(t_IMAGEHEADER) + BPHDS - 1) / BPHDS)

#endif /* ndef _IMAGHEAD_h_ */

