
%NOLIST
;============================================================================
;
; IMAGHEAD.INC
; Header of a cdrom-image for PseudoCD-drivers
; This file is part of the
;
; PseudoCD package (version 02)
; Copyright (C) 1997  C.Kulms
;
;   This is free software; you can redistribute it and/or modify it
;   under the terms of the GNU General Public License as published by
;   the Free Software Foundation; version 2 of the License.
;
;   This software is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this software; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;============================================================================

; This file is included by the driver source (PSEUDOCD.ASM).
; Note that the file IMAGHEAD.H must be consistent with this!

%LIST

;sector-sizes
BPHDS	EQU 512			;bytes per hd-sector
BPHDSsh	EQU 9			;-"- as shift value
BPHDSmk	EQU 0FE00h		;mask for offset in hd-sector
BPCDS	EQU 2048		;bytes per cd-sector (cooked)
BPCDSsh	EQU	11			;-"- as shift value
BPCDRAW	EQU 2352		;bytes per cd-sector (raw-mode)
SPCDS	EQU 4			;hd-sectors per (cooked) cd-sector
SPCDSsh	EQU 2			;-"- as shift value

SIGNLEN		EQU 32					;max. length of signature
SIGNATURE 	EQU "PSEUDOCD-IMAGE header version 01"	;signature of image
IMGCOMSIZE	EQU 78					;max. size of comment

STRUC sTRACKINFO			;data returned by 'audio track info'
tiStart	dd 0				;start-address of track (red-book)
tiCtrl	db 0				;ctrl/adr bits
ENDS sTRACKINFO

LABEL		ImageHeader BYTE

; data of cdrom
LowTrack	DB 0			;lowest track number (binary)
HighTrack	DB 0			;highest track number (binary)
VolSize		DD 0			;volume size (as (min*60+sec)*75+fra = sectors)
LeadOut		DD 0			;red-book address of lead-out track (min/sec/fra)
TotBytes	DD 0			;size in bytes (cooked)
TotSize		DD 0			;total cd-size in cd-sectors
			    			;=VolSize+start_of_first_track
							;=lead-out track address (binary)
TotHdSecs	DD 0			;total size in hd-sectors (=TotSize*SPCDS)
TrackInfo	sTRACKINFO 99 DUP(?)		;info for each track
			;('audio track info') this will be shorted by the driver at
			;installation so not the entire array will be hold in memory

; data used by driver to identify valid image
Signature	DB SIGNATURE	;for validity check

IF SIGNLEN - SIZE Signature NE 0
			DB SIGNLEN - SIZE Signature DUP(0)
ENDIF

; user's comment
ImgComment	DB IMGCOMSIZE+1 DUP('$')	;user's comment

LABEL		ImageHeaderEnd BYTE
IMGHDRSIZE	= ImageHeaderEnd - ImageHeader
IMGHDRSEC	= (IMGHDRSIZE + BPHDS - 1) SHR BPHDSsh
			DB (IMGHDRSEC SHL BPHDSsh) - IMGHDRSIZE DUP(0)
			;(hd-sector alignment)

