/*
ͻ
                     WordUp Graphics Toolkit Version 4.5                    
                            Demonstration Program 46                        
                                                                            
 This example shows the use of the whline command to draw fast horizontal   
 lines. It will also use the wtimer command to make the demo run for as     
 close to 5 seconds as possible (regardless of CPU speed).                  
                                                                            
  PROJECT                                                             
 This program requires the WGT45.LIB file to be linked.                     
                                                                            
  DATA FILES                                                          
 None.                                                                      
                                                                            
ͼ
*/

#include <dos.h>
#include <stdlib.h>
#include <wgt45.h>

int loopctr;

void far timerctr (void)
{
  loopctr++;
}


void main (void)
{
short row;
short oldmode;

  if (!vgadetected ())
    {
     printf ("Error - VGA card required for any WGT program.\n");
     exit (0);
    }

  printf ("WGT Example #46\n\n");
  printf ("Horizontal lines are blasted to the screen for a 5 second period.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  oldmode = wgetmode ();        /* Gets the current mode        */
  vga256 ();                    /* Initializes WGT system       */
  wcls (0);                     /* Clear screen with color 0    */

  row = 0;                      /* Start drawing at top row of screen */
  loopctr = 0;
  winittimer ();
  wstarttimer (timerctr, 100);  /* Set timer to 100th of a second accuracy */
  do {
    wsetcolor (rand () % 256);  /* Pick a random color */
    whline (0, 319, row++);     /* Draw the line */
    if (row > 199)              /* Loop at end of screen */
      row = 0;
  } while (loopctr < 500);       

  /* As soon as we reach 500 hundredths of a second (5 secs), end the routine
     and reset the video mode */
  wstoptimer ();
  wdonetimer ();
  wsetmode (oldmode);            /* Restore old video mode       */
}

