/**********************************************************/
/* Program Id.               Int24tst.C                   */
/* Author.                   Stan Milam.                  */
/* Date Written.             11/08/89.                    */
/*                                                        */
/* Demonstrates the Critical Interrupt capabilities of PCW*/
/*    1.  Access disk drive that is not ready.            */
/*    2.  Write to printer that is not ready.             */
/*    3.  Write to AUXillary device (not ready).          */
/*    4.  Write to LPT1 device (not ready).               */
/**********************************************************/

#include <stdio.h>
#include <dos.h>
#ifdef __ZTC__
#  include <direct.h>
#else
#  include <dir.h>
#endif
#include <pcwproto.h>

static char *blkmsg[] = {
   "This program is a demonstration  of PC Window's Critical",
   "Interrupt capablities.  Instead  of seeing  the  familar",
   "\"Abort, Retry, Ignore\" PCW will capture the DOS Critical",
   "Interrupt and use a window with a  menu to ask what  you",
   "want to do. When you make a choice  the window goes away",
   "leaving your screen as it was before  the error. To make",
   "this demonstration work  please turn  off  your  printer",
   "and open the door to drive  A:. If you have a modem turn",
   "it off too.  Press any key  to start the demonstration. ",
   NULL
};

/**********************************************************/
/*                      device_write()                    */
/*                                                        */
/* Open the device passed and attempt to write the string */
/* "Hello World!". If the device is inactive INT 24 will  */
/* be called by DOS and guess who is taking care of INT 24*/
/**********************************************************/

void device_write(char *device) {

   FILE  *fp;
   static char *msg = "Hello World!";

   fp = fopen(device, "w");
   if (fp != NULL) {
      if (fputs(msg, fp) == EOF)
         printf("Error Writing to device %s\n",device);
      fclose(fp);
   }
   else {
      printf("Error opening device: %s\n", device);
   }
}

void main(void) {

  WNDPTR *wnd, *savewnd;
  int mxr, mxc;
#ifdef MSC
  struct find_t file_block;
#endif
#ifdef (__ZTC__)
  struct FIND  file_block;
#endif
#ifdef __TURBOC__
  struct ffblk file_block;
#endif
#ifdef __POWERC
  struct ffblk file_block;
#endif

  bordercolor(RED,LIGHTGRAY);
  titlecolor(BLUE,LIGHTGRAY);
  wnd = wframe(6,10,18,70,BLACK,LIGHTGRAY);
  wtitle(wnd,TOP,MIDDLE," Critical Interrupt Demonstration ");
  w_block_write(wnd,2,99,blkmsg);
  keywait(60);
  wnd = wpop(wnd);
  set_int24();
  qputs(1,99,15,0,"    Attempting to access Drive A:   ");
#if MSC || __ZTC__
  _dos_findfirst("a:*.*",0,&file_block);
#else
  findfirst("a:*.*",&file_block,0);
#endif
  qputs(1,99,BLUE,0,  "      Now writing to file A:File    ");
  device_write("A:FILE");
  qputs(1,99,RED,0,   "      Now writing to device PRN     ");
  device_write("PRN");
  qputs(1,99,GREEN,0, "      Now writing to device AUX     ");
  device_write("AUX");
  qputs(1,99,YELLOW,0,"      Now writing to device LPT1    ");
  device_write("LPT1");
}
