/*
 *                              OPTIONS.C
 *
 *                           Written for the
 *
 *                              Datalight
 *                           Microsoft V 5.x
 *                                TurboC
 *                                  &
 *                               Zortech
 *
 *                             C Compilers
 *
 *            Copyright (c) John Birchfield 1987, 1988, 1989
 */

#include <stdio.h>
#include "options.h"

#if (!defined (TRUE))
#	define TRUE  (1)
#	define FALSE (0)
#endif

int     Port = 1;

char	Opt_Msg [159] = { 0 },
        Baud_rate[] = "1200",
        Parity[] = "N",
		Data[] = "8",
		Stop[] = "1",

		Cfg_Str[15] = { 0 };


int  good_baud (char *);
void usage (void);

void 
set_options (int cnt, char **args)
{
    char   *ch;
    int   c_flag = 0;
    while (--cnt > 0)
    {
        ch = *++args;
        if (*ch == '?')
        	usage ();
        if (*ch == '-')
            switch (toupper (*++ch))
            {
                case 'C':
                    switch (*++ch)
                    {
                        case '1':
                            Port = 1;
                            break;
                        case '2':
                            Port = 2;
                            break;
                        default:
                            usage ();
                            break;
                    }
                    break;
                case 'B':
                    c_flag = TRUE;
                    if (good_baud (++ch))
                        strcpy (Baud_rate, ch);
                    else
                        usage ();
                    break;
                case 'P':
                    c_flag = TRUE;
                    switch (toupper (*++ch))
                    {
                        case 'E':
                            Parity[0] = 'E';
                            break;
                        case 'O':
                            Parity[0] = 'O';
                            break;
                        case 'N':
                            Parity[0] = 'N';
                            break;
                        default:
                            usage ();
                            break;
                    }
                    break;
                case 'S':
                    c_flag = TRUE;
                    switch (*++ch)
                    {
                        case '1':
                            Stop[0] = '1';
                            break;
                        case '2':
                            Stop[0] = '2';
                            break;
                        default:
                            usage ();
                            break;
                    }
                    break;
                case 'D':
                    c_flag = TRUE;
                    switch (*++ch)
                    {
                        case '7':
                        case '8':
                            Data[0] = *ch;
                            break;
                        default:
                            usage ();
                            break;
                    }
                    break;
                default:
                    break;
            }
    }
    if (c_flag)
    {
		sprintf (Opt_Msg, "%s %d %s%s%s %s%s %s%s %s%s\n",
		                  "Com Port", Port, "Initialized  %--%  ",
		                  "   Baud=", Baud_rate, "Parity=", Parity,
						  "Data=", Data, "Stop=", Stop);
	    strcpy (Cfg_Str, Baud_rate);
	    strcat (Cfg_Str, " ");
	    strcat (Cfg_Str, Parity);
	    strcat (Cfg_Str, " ");
	    strcat (Cfg_Str, Stop);
	    strcat (Cfg_Str, " ");
	    strcat (Cfg_Str, Data);
	}
}





static char *baud_rates[] =
{
 "300", "600", "1200", "2400", "4800", "9600", "19200", 0
};

int 
good_baud (char *s)
{
    int     i;
    for (i = 0; baud_rates [i]; i++)
        if (strcmp (baud_rates[i], s) == 0)
            return (TRUE);
    return (0);
}



void
usage (void)
{
    fputs ("Use the following command line options.\n\n", stderr);
    fputs ("   -C[1 or 2] Com Port 1 or 2      {Default Com Port 1}\n", stderr);
    fputs ("   -B[300 600 1200 2400 4800 9600] {Default 9600 Baud}\n", stderr);
    fputs ("   -D[7 or 8]  Data Bits           {Default 8}\n", stderr);
    fputs ("   -S[1 or 2] Stop Bits            {Default 1}\n", stderr);
    fputs ("   -P[E O or N] Parity             {Default None}\n\n", stderr);
    fputs ("   -b2400 -pn -s1 -d8 -c1\n\n", stderr);
    exit (1);
}

