/*
 *                               DELAY.C
 *
 *                           Written for the
 *
 *                              Datalight
 *                           Microsoft V 5.x
 *                                TurboC
 *                                  &
 *                               Zortech
 *
 *                             C Compilers
 *
 *            Copyright (c) John Birchfield 1987, 1988, 1989
 *
 *	This module implements a more or less machine independent delay
 *	loop - the general idea is we kinda tie the delay loop to the 
 *	Timer Interrupt to get a general idea of how big the loop counter
 *	has to be to count off a millisecond.  Crude eh?
 */

/*
 *	We'll take the stand-alone testing stuff out entirely
 *	one of these days.
 */

unsigned long int timer_read ();

#if (defined (TEST))
#	include <stdio.h>
#	include <time.h>
main ()
{
    long    starttime, stoptime;
    DELAY_init ();
    printf ("\n\nBegin %d millisecond delay\n\n", 30000);
    time (&starttime);
    DELAY_loop (30000);
    time (&stoptime);
    printf ("End - Elapsed time = %ld\n", stoptime - starttime);
    timer_term ();
}

#endif


static unsigned int DELAY_millisecond;
void
DELAY_init (void)
{
	static d_init = 0;
    long    l;
    if (d_init)
    	return;
    d_init = 0;
    timer_init ();
    timer_set ();
    while (timer_read () == 0L);
    timer_set ();
    for (l = 0L; l != -1L; l++)
        if (timer_read () == 3)
            break;
    l *= 197;
    DELAY_millisecond = (int) ((l + 5000) / 10000);
}
static unsigned int _DELAY_cnt, _DELAY_ix;

int 
DELAY_loop (int msc)
{
    for (_DELAY_ix = 0; _DELAY_ix < msc; _DELAY_ix++)
        for (_DELAY_cnt = 0; _DELAY_cnt < DELAY_millisecond; _DELAY_cnt++);
    return (msc);
}
