/*===================================================================
 noncdist.h

 Version 1.1

 Written by:
   Brent Worden
   WordenWare
   email:  brent@worden.org

 Copyright (c) 1998-2001 WordenWare

 Created:  August 28, 1998
 Revised:  March 26, 2001
===================================================================*/

#ifndef _NONCDIST_H_
#define _NONCDIST_H_

#include "numerics.h"

NUMERICS_EXPORT double ncbetap(double x, double a, double b, double lambda);
/*-------------------------------------------------------------------
 Returns the value of Non-central Beta random variable distribution
 function with alpha a, beta b, and non-centrality parameter lambda
 at the value x.
-------------------------------------------------------------------*/

NUMERICS_EXPORT double ncbetav(double p, double a, double b, double lambda);
/*-------------------------------------------------------------------
 Returns the critical point of the Non-central Beta random variable
 distribution function with alpha a, beta b, and non-centrality
 parameter lambda associated with probability p.
-------------------------------------------------------------------*/

NUMERICS_EXPORT double ncchisqp(double x, double df, double delta);
/*-------------------------------------------------------------------
 Returns the value of Non-central Chi-square random variable
 distribution function with df degrees of freedom and
 non-centrality parameter delta at the value x.
-------------------------------------------------------------------*/

NUMERICS_EXPORT double ncchisqv(double p, double df, double delta);
/*-------------------------------------------------------------------
 Returns the critical point of the Non-central Chi-square random
 variable distribution function with df degrees of freedom and
 non-centrality parameter delta associated with probability p.
-------------------------------------------------------------------*/

NUMERICS_EXPORT double ncstudtp(double x, double df, double delta);
/*-------------------------------------------------------------------
 Returns the value of Non-central Student's T random variable
 distribution function with df degrees of freedom and
 non-centrality parameter delta at the value x.
-------------------------------------------------------------------*/

NUMERICS_EXPORT double ncstudtv(double p, double df, double delta);
/*-------------------------------------------------------------------
 Returns the critical point of the Non-central Student's T random
 variable distribution function with df degrees of freedom and
 non-centrality parameter delta associated with probability p.
-------------------------------------------------------------------*/

#endif

/*===================================================================
 Revision History

 Version 1.0 - 08/28/1998 - New.
 Version 1.1 - 03/26/2001 - Added ncbetap, ncbetav, ncstudtv,
                            ncchisqp, ncchisqv
===================================================================*/
