// Letter Adjacency Table Header File
//
// Author : Guy W. Lecky-Thompson
//
// (c) 2003 Guy W. Lecky-Thompson
//
// This file may be distributed under the
// terms of the GNU General Public License.

#include <stdio.h>
#include <stdlib.h>

#include "letter_table_ci.h"

#define REPEAT_COUNT 2 // The number of times we will allow a letter to repeat itself

// The function to select a letter based on the adjacency values, 
// with no regard for proportions
int SimpleChooseLetter(LETTER_TABLE lLetterTable, char cPrevious)
{
  int nChoice; // The chosen letter
  int nPrevious; // The letter to use in the preceding slot
  int nSumCounter; // For checking whether cPrevious has
  long lSum;       // any adjacent characters...

  // Get the column reference based on the starting letter
  nPrevious = (cPrevious - 'a') + 1;
  // Adapt for spaces or other characters
  if (nPrevious <= 0) nPrevious = 0;

  lSum = 0;
  for (nSumCounter = 0; nSumCounter < 28; nSumCounter++)
  {
    lSum = lSum + lLetterTable[nPrevious][nSumCounter];
  }
  
  do
  {
    nChoice = rand() % 28; // Pick a cell
  } while (lLetterTable[nPrevious][nChoice] == 0);

  // Change nChoice from a reference into a character
  if ((nChoice == 0) || (nChoice == 27))
    nChoice = ' ';
  else
    nChoice = 'a' + (nChoice - 1);

  return nChoice;
}

// The function to select a letter based on the adjacency values, using a reasonably
// sophisticated method
int ChooseLetter(int prev, LETTER_TABLE letter_table)
{
  long int lSum, lCurr,lTarget; // Entry total, running total and target value
  int i;                        // Generic counter
  lSum = 0;
  for (i = 0; i < 28; i++)      // Scroll through the table, adding adjacency values
  {
    lSum = lSum + letter_table[prev][i];
  }
  if (lSum == 0) return 0;    // If there are no possible values, return a space
  lCurr = 0;
  lTarget = rand() % lSum;      // We want to stop at lSum
  for (i = 0; i < 28; i++)
  {
    lCurr = lCurr + letter_table[prev][i];
    if (lCurr >= lTarget)       // If we are at the target value, or higher, stop
    {
      if ((i == 27)||(i == 0)) return 0;
      return i;
    }
  }
  return 0;  // No possible values, return space (code never executed?)
}

int main ( int argc, char ** argv)
{
  int prev;        // Previous letter
  int curr;        // Current letter
  int i;           // Generic counter
  int repetition;  // Repetition counter
  int nospace;     // Characters since last space
  
  LETTER_TABLE lLetterTable; // Our generated adjacency table, from letter_table.h

  InitialiseLetterTable(lLetterTable); // Build it from letter_table.c
  
  srand(1); // Randomize with a static seed for check purposes. Use srand(time(NULL)) for real applications
  
  prev = SimpleChooseLetter(lLetterTable,' '); // Pick a starter, using a ' ' in the 0th column of lLetterTable
  curr = prev;
  
  repetition = 0; // Init. repeition counter
  nospace = 0;    // Init. space counter
  
  printf("\nUsing SimpleChooseLetter:\n");
  
  for (i = 0; i < (20*80); i++) // Generate a screenful of text
  {
    if ((curr == prev) && (curr == ' ')) curr = SimpleChooseLetter(lLetterTable,prev); // Eliminate double spaces
    if (curr != prev) repetition = 0;  // Reset repeition counter
    if (curr == prev) repetition++;    // Letter chaining
    if (repetition == REPEAT_COUNT)    // If there are more REPEAT_COUNT letters in a row...
    {
      curr = SimpleChooseLetter(lLetterTable,prev);  // ...pick another
      repetition = 0;                          // Reset repetition counter
    }
    if (curr != ' ') nospace++; else nospace = 0;  // Space counting...
    if (nospace >= LONGEST_COUNTRY_NAME) { curr = 0; nospace = 0; } // If we haven't had a space for a while, insert one
    printf("%c",curr); // Print the character, a = 1, b = 2 etc.
    prev = curr; // Set previous to current, and back to the top for another letter    
    curr = SimpleChooseLetter(lLetterTable,prev); // Choose a letter
  }  
  
  srand(1);
  prev = ChooseLetter(0,lLetterTable); // Pick a starter, using a ' ' in the 0th column of lLetterTable
  curr = prev;
  repetition = 0; // Init. repeition counter
  nospace = 0;    // Init. space counter

  printf("\nUsing ChooseLetter:\n");
  for (i = 0; i < (20*80); i++) // Generate a screenful of text
  {
    if ((curr == prev) && (curr == 0)) curr = ChooseLetter(prev,lLetterTable); // Eliminate double spaces
    if (curr != prev) repetition = 0;  // Reset repeition counter
    if (curr == prev) repetition++;    // Letter chaining
    if (repetition == REPEAT_COUNT)    // If there are more REPEAT_COUNT letters in a row...
    {
      curr = ChooseLetter(prev,lLetterTable);  // ...pick another
      repetition = 0;                          // Reset repetition counter
    }
    if (curr != 0) nospace++; else nospace = 0;  // Space counting...
    if (nospace >= LONGEST_COUNTRY_NAME) { curr = 0; nospace = 0; } // If we haven't had a space for a while, insert one
    if (curr == 0) 
    {
      printf(" "); // 0 means space. As does 27, but we dealt with that in ChooseLetter
    }
    else
    {
      printf("%c",(curr-1)+'a'); // Print the character, a = 1, b = 2 etc.
    }
    prev = curr; // Set previous to current, and back to the top for another letter
    curr = ChooseLetter(prev,lLetterTable); // Choose a letter
  }
  // We're done.
}

