/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details  */
/* Adapted for Metaware High C/C++ & Pharlap by G. Vanem 1997 */

#include <stdio.h>
#include <signal.h>
#include "mwutil.h"

int _ungetch_x  = 0;   /* mw_ungetch_x */
int _char_avail = 0;

int getche (void)
{
  if (_char_avail)
    /*
     * We don't know, whether the ungot char was already echoed.
     * We assume yes (for example in cscanf, probably the only
     * place where ungetch is ever called.
     * There is no way to check for this really, because
     * ungetch() could have been called with a character that
     * hasn't been got by a conio function. We don't echo again.
     */ 
     return (getch());
  return (putch(getch()));
}

int getch (void)
{
  SWI_REGS regs;
  int c;

  if (_char_avail)
  {
    c = _ungetch_x;
    _char_avail = 0;
  }
  else
  {
    regs.eax = 0x0700;
    _dx_real_int (0x21,&regs);
    c = regs.eax & 255;
  }
  return (c);
}

int ungetch (int c)
{
  if (_char_avail)
     return (EOF);
  _ungetch_x  = c;
  _char_avail = 1;
  return (c);
}

