#############################################################################
#
#                       Copyright (C) 1994 SciTech Software
#                               All rights reserved.
#
# Descripton:   Generic DMAKE startup makefile definitions file. Assumes
#               that the SCITECH environment variable has been set to point
#               to where all our stuff is installed. You should not need
#               to change anything in this file.
#
#               Watcom C++ 10.x 32 bit version. Supports Rational's DOS4GW
#               DOS Extender, Phar Lap's TNT DOS Extender and 32 bit
#               Windows development.
#
# $Id: wc32.mk 1.4 1995/09/26 12:37:11 kjb release $
#
#############################################################################

# Disable warnings for macros redefined here that were given
# on the command line.
__.SILENT       := $(.SILENT)
.SILENT         := yes

# File suffix definitions
   L            := .lib   # Libraries
   E            := .exe   # Executables
   O            := .obj   # Objects
   A            := .asm   # Assembler sources
   P            := .cpp   # C++ sources
   D            := .dll   # Dynamic Link Library file
   R            := .res   # Compiled resource file

# Import enivornment variables that we use
TMPDIR := $(ROOTDIR)/tmp
.IMPORT .IGNORE : TMPDIR COMSPEC INCLUDE LIB SCITECH DBG OPT OPT_SIZE SHW BETA
.IMPORT .IGNORE : USE_TNT USE_X32 USE_X32VM USE_PMW USE_WIN32 FPU STKCALL
.IMPORT .IGNORE : BUILD_DLL IMPORT_DLL USE_TASMX

# We use the MSDOS shell at all times
   SHELL        := $(COMSPEC)
   GROUPSHELL   := $(SHELL)
   SHELLFLAGS   := $(SWITCHAR)c
   GROUPFLAGS   := $(SHELLFLAGS)
   SHELLMETAS   := *"?<>
   GROUPSUFFIX  := .bat
   DIRSEPSTR    := \\
   DIVFILE       = $(TMPFILE:s,/,\)

# Default commands for compiling, assembling linking and archiving
   CC           := wcl386   # C-compiler and flags
   CFLAGS       := -zq-w2-s-fh -fhq
.IF $(USE_TASMX)
   AS           := tasmx    # Assembler and flags
.ELSE
   AS           := tasm     # Assembler and flags
.ENDIF
   ASFLAGS      := /mx /m /D__FLAT__ /i$(SCITECH)\INCLUDE
   LD           := wlink    # Loader and flags
   LDFLAGS       =
   RC           := wrc      # Watcom resource compiler
   RCFLAGS      := /bt=nt   # Mark as Win32 compatible resources
   LIB          := wlib     # Librarian
   LIBFLAGS     := -q
   ILIB         := wlib     # Import librarian
   ILIBFLAGS    := -c

# Optionally turn on debugging information
.IF $(DBG)
   CFLAGS       += -d2      # Turn on debugging for C compiler
   LIBFLAGS     += -p=128   # Larger page size for libraries with debug info!
   ASFLAGS      += /zi      # Turn on debugging for assembler
   LDFLAGS      += D A      # Turn on debugging for linker
.ELSE
   ASFLAGS      += /q       # Suppress object records not needed for linking
.END

# Optionally turn on optimisations (with or without stack conventions)
.IF $(STKCALL)
.IF $(OPT)
   CFLAGS       += -onatx-5s
.ELIF $(OPT_SIZE)
   CFLAGS       += -onaslmr-5s
.ELSE
   CFLAGS       += -3s
.END
.ELSE
.IF $(OPT)
   CFLAGS       += -onatx-5r
.ELIF $(OPT_SIZE)
   CFLAGS       += -onaslmr-5r
.END
.END

# Optionally turn on direct i387 FPU instructions optimised for Pentium

.IF $(FPU)
   CFLAGS       += -fpi87-fp5-DFPU387
   ASFLAGS      += -DFPU387
.END

# Optionally compile a shareware version of a product
.IF $(SHW)
   LIB_DIR      := LIBSW
   CFLAGS       += -DSHAREWARE
.ELSE
   LIB_DIR      := LIB
.END

# Optionally compile a beta release version of a product
.IF $(BETA)
   CFLAGS       += -DBETA
   ASFLAGS      += -DBETA
.END

# Use a larger stack during linking if requested, or use a default stack
# of 50k. The usual default stack provided by Watcom C++ is *way* to small
# for real 32 bit code development.

.IF $(STKSIZE)
    LDFLAGS     += OP STACK=$(STKSIZE)
.ELSE
    LDFLAGS     += OP STACK=51200
.ENDIF

.IF $(USE_TNT)                  # Use Phar Lap's TNT DOS Extender
    LDFLAGS      += SYS NT OP STUB=GOTNT.EXE
    DX_CFLAGS    += -DTNT
    DX_ASFLAGS   += -DTNT
    LIB_OS       = DOS32
.ELIF $(USE_X32VM)              # Use FlashTek X-32VM DOS extender
    LDFLAGS      += SYS X32RV
    DX_CFLAGS    += -DX32VM
    DX_ASFLAGS   += -DX32VM
    LIB_OS       = DOS32
.ELIF $(USE_X32)                # Use FlashTek X-32 DOS extender
    LDFLAGS      += SYS X32R
    DX_CFLAGS    += -DX32VM
    DX_ASFLAGS   += -DX32VM
    LIB_OS       = DOS32
.ELIF $(USE_WIN32)              # Build 32 bit Windows NT app
.IF $(BUILD_DLL)
    CFLAGS       += -bd-bt=nt-DBUILD_DLL
    ASFLAGS      += -DBUILD_DLL
.ELSE
    CFLAGS       += -bt=nt
.ENDIF
    DX_ASFLAGS   += -D__WINDOWS32__
    LIB_OS       = WIN32
.ELIF $(USE_PMW)                # PMODE/W
    USE_DOS4GW   := 1
    LDFLAGS      += SYS PMODEW
    DX_CFLAGS    += -DDOS4GW
    DX_ASFLAGS   += -DDOS4GW
    LIB_OS       = DOS32
.ELSE                           # Use DOS4GW
    USE_DOS4GW   := 1
    DX_CFLAGS    += -DDOS4GW
    DX_ASFLAGS   += -DDOS4GW
    LIB_OS       = DOS32
.END

# Place to look for PMODE library files

.IF $(MK_PMODE)
.ELIF $(USE_TNT)
PMLIB           := tnt\pmode.lib,
.ELIF $(USE_X32)
PMLIB           := x32\pmode.lib,
.ELSE
PMLIB           := dos4gw\pmode.lib,
.END

# Define where to install library files
   LIB_BASE     := $(SCITECH)\$(LIB_DIR)\$(LIB_OS)\WC
   LIB_DEST     := $(LIB_BASE)

# Definition of $(MAKE) macro for recursive makes.
   MAKE = $(MAKECMD) $(MFLAGS)

# Macro to install a library file
   INSTALL      := cp

# Implicit generation rules for making object files
   %$O: %.c ; +$(CC) $(CFLAGS) -c $<
   %$O: %$P ; +$(CC) $(CFLAGS) -c $<
   .SWAP %$O: %$A ; +$(AS) $(ASFLAGS) $(<:s,/,\)

# Implicit rule for building resource files
   %$R: %.rc ; +$(RC) $(RCFLAGS) -r $<

# Implicit rule for building a DLL using a response file
   .SWAP %$D: ;
@[
    @trimlib $(mktmp $(LDFLAGS) OP quiet SYS nt_dll\nN $@\nF $(&:t",\n":s/\/\\)\nLIBR $(EXELIBS:t",")) $*.lnk
    rclink $(LD) $(RC) $@ $*.lnk
    @rm $*.lnk
]

# Implicit rule for building a library file using response file
.IF $(BUILD_DLL)
   %$L: ; $(ILIB) $(ILIBFLAGS) $@ +$?
.ELIF $(IMPORT_DLL)
   %$L: ; $(ILIB) $(ILIBFLAGS) $@ +$?
.ELSE
.IF $(STKCALL)
   %$L: ; +$(LIB) $(LIBFLAGS) s$@ @$(mktmp,$*.rsp -+$(?:t"\n-+":s/\/\\)\n)
.ELSE
   %$L: ; +$(LIB) $(LIBFLAGS) $@ @$(mktmp,$*.rsp -+$(?:t"\n-+":s/\/\\)\n)
.ENDIF
.ENDIF

# Implicit rule for building an executable file using response file
.IF $(USE_TNT)
   .SWAP %$E: ; +$(LD) $(LDFLAGS) @$(mktmp,$*.lnk OP quiet\nN $@\nF $(&:t",":s/\/\\)\nLIBR dosx32.lib,$(PMLIB)$(EXELIBS:t","))
.ELIF $(USE_X32)
   .SWAP %$E: ;
@[
    @trimlib $(mktmp OP quiet\nN $@\nF $(&:t",":s/\/\\)\nLIBR $(PMLIB)$(EXELIBS:t",")) $*.lnk
    $(LD) $(LDFLAGS) @$*.lnk
    x32fix $@
    @rm $*.lnk
]
.ELIF $(USE_WIN32)
   .SWAP %$E: ;
@[
    @trimlib $(mktmp $(LDFLAGS) OP quiet SYS nt_win\nN $@\nF $(&:t",":s/\/\\)\nLIBR $(EXELIBS:t",")) $*.lnk
    rclink $(LD) $(RC) $@ $*.lnk
    @rm $*.lnk
]
.ELSE
   .SWAP %$E: ;
@[
    @trimlib $(mktmp OP quiet\nN $@\nF $(&:t",":s/\/\\)\nLIBR $(PMLIB)$(EXELIBS:t",")) $*.lnk
    $(LD) $(LDFLAGS) @$*.lnk
    @rm $*.lnk
]
.ENDIF

# DMAKE uses this recipe to remove intermediate targets
.REMOVE :; $(RM) -f $<

# Turn warnings back to previous setting.
.SILENT := $(__.SILENT)

# We dont use TABS in our makefiles
.NOTABS         := yes

# Define where the local include files are kept for dependencies in
# makefiles after this file is included.

RCSINC :=  $(SCITECH)\INCLUDE

