/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gjA(int n)
{
int    i;
int col1;
int col2;
int rank;

double pbv  [MXR][MXC*TWOCOL];matrix mv  ={MXR,MXC*TWOCOL,&pbv  [0][0]};
double pbvT [MXR][MXC*TWOCOL];matrix mvT ={MXR,MXC*TWOCOL,&pbvT [0][0]};

                    mv.rows = n;         mv.cols = (n+1)*TWOCOL;
                   mvT.rows = n;        mvT.cols =  n   *TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
   rndm0F(&mvT,4,2);
    mzero(&mv);
   copymF(&mvT,&mv);

   for(i=0;i<4;i++)
   {
    col1 = rndp0I(n-1);
    col2 = rndp0I(n-1);
    copyrowF(&mv,col1,&mv,col2);
   }

   clrscrn();

   printf("\n Rank(A) : Is the number of leading variables in the solution of Ax = 0.\n");
   printf("\n If the augmented matrix of the system is  :\n");
   printmF3(     &mv);
   gaussjordanF( &mv);
   printf("\n The reduced row echelon form is :\n");
   printmF3(     &mv);
   rank = rankmF(&mv);
   printf("\n rank = %d \n",rank);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n                     Rank(A) :                  \n");
  printf("\n       Is the number of leading variables         ");
  printf("\n         in the solution of Ax = 0.               ");
  printf("\n         **************************             \n");
  printf("\n The size of mv : 2x3 ... 4x5.                  \n");
  printf("\n           ex : \"rankR.exe\"                   \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"rankR.exe 2\" -> mA 2x3         ");
  printf("\n                \"rankR.exe 3\" -> mA 3x4         ");
  printf("\n                \"rankR.exe 4\" -> mA 4x5         ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press Return to continue                         ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
   int n = 2;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {
  ++n;
  if(n>6){n=2;}
 }

if(n<2){n=2;}


  gjA(n);


printf("\n Press 'X' Return to stop :\n");
} while(toupper(getchar())!='X');

  return 0;
}

