/**  doslocal.c **********************************************************

     Locales' support for DOS / Win31 / Win32.
            Copyright (c) 1995-1997  by Timofei Bondarenko <tim@ipi.ac.ru>

     Encoding of locales values: _lc_str2cp_(), _lc_cp2str_().
     Obtaining localization tables from DOS: _dos_getLC_().
 *-----------------------------------------------------------------------*/
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if    defined(_Windows)
#include "win.h"
#elif  defined(__DJGPP__)
#include <dpmi.h>
#include <go32.h>
#elif !defined(__BORLANDC__) && !defined(_MSC_VER)
/* unknown style of __asm statement */
#include <dos.h>
#endif
#if   2 & DOS_FAR_MODE
#include <stddef.h> /* offsetof() */
#endif
#include "_locale.h"

#if   defined(USE_OLENLS)

LC_ID_ _lc_Intl_lcid;

int _lc_getLocaleInt(int entry)
{
 char tmp[16];
 return GetLocaleInfoA(_lc_Intl_lcid, entry, tmp, sizeof(tmp)) > 0 ?
        (int)strtoul(tmp, NULL, 10): _LOCALEINT_BAD;
}

#elif defined(_Windows)

const char _lc_Intl_sect[] = "Intl";

#endif /*_Windows*/

#if defined(USE_OLENLS) || !defined(_Windows)
/*#if definde(USE_OLENLS) \
 && LOCALE_USER_DEFAULT != _lcn_DEF_
#error Wrong value of _lcn_DEF_
#endif*/

#if LCS_ != 8
#error Bad value of LCS_
#endif

unsigned long _lc_str2lid_(const char *str)
{
 if (str[0] == 'C' &&
    (str[1] == ' ' || str[1] == '\0')) return _lcn_C_;
{
#ifdef    USE_OLENLS
 unsigned long rv = strtoul(str, NULL, 16);
/* if (endp != str+8 || *endp && *endp != lcBRK_) return _lcn_BAD_;*/
#ifdef    __WIN32__
 if (!IsValidLocale(rv =
      ConvertDefaultLocale(rv), LCID_INSTALLED)) return _lcn_BAD_;
#else
 if (rv == LOCALE_USER_DEFAULT) return GetUserDefaultLCID();
 if (rv == LOCALE_SYSTEM_DEFAULT) return GetSystemDefaultLCID();
#endif
 return rv;
#else  /*!USE_OLENLS*/ /* DOS */
 ldiv_t dd;
 if ((unsigned long)(dd.rem = atol(str)) > 99999999ul)
   return _lcn_BAD_;
 dd = ldiv(dd.rem, 10000L);
 if ((unsigned)dd.rem  == 9999) dd.rem  = 0xfffful;
 if ((unsigned)dd.quot == 9999) dd.quot = 0xfffful;

 return (unsigned short)dd.rem | dd.quot << 16;
#endif /*!USE_OLENLS*/ /* DOS */
}
}

void _lc_lid2str_(char *str, unsigned long ccp)
{
 if (ccp == _lcn_C_) strcpy(str, _lcs_C_);
 else
#ifdef    USE_OLENLS
    sprintf(str, ccp == _lcn_BAD_? "????????": "%08lX", ccp);
#else  /*!USE_OLENLS*/ /* DOS */
   {
#define cpSH ((short*)&ccp)
    if (cpSH[0] == (short)0xffff) cpSH[0] = 9999;
    if (cpSH[1] == (short)0xffff) cpSH[1] = 9999;
    ccp = cpSH[0] + cpSH[1] * 10000L;
#undef  cpSH
    sprintf(str, ccp > 99999999ul? "????????": "%08lu", ccp);
   }
#endif /*!USE_OLENLS*/ /* DOS */
}

#endif  /*USE_OLENLS || !_Windows */

#ifndef   _Windows

#define LINEAR_FROM_FAR16(addr)        (            \
            (0x00ffffL & (addr)) +      /* offset */\
            (0x0ffff0L & (addr) >> 12) )/* segment */

int _dos_getLC_(void *buf, unsigned bufsize,
                unsigned table, unsigned long ccp)
{
#define Buf ((struct _dos_LCT_ *)buf)
/********************************************************************/
#if 1 >= DOS_FAR_MODE  /* Real Mode 16 bit */
#if defined(__BORLANDC__) || defined(_MSC_VER)
 __asm {
        mov  ax, table
        mov  bx, word ptr ccp[2]  /* BX = code page */
        mov  cx, bufsize
        mov  dx, word ptr ccp[0]  /* DX = country   */
        push di
       }
#if 0 == DOS_FAR_MODE
 __asm  les  di, dword ptr buf
#else
 __asm  mov  di, buf
 __asm  push ss
 __asm  pop  es
#endif
 __asm {
        mov  ah, 65h
        int  21h
        pop  di
        jc   Error
       }
#else  /*!defined(__BORLANDC__) && !defined(_MSC_VER)*/
 union   REGS  r;             /* General 16 bit code */
 struct SREGS sr;
// segread(&sr);
 r.h.al = table;
 r.h.ah = 0x65;
 r.x.bx = ccp >> 16;
 r.x.dx = ccp;
 r.x.cx = bufsize;
 r.x.di = FP_OFF((void DOS_FAR *)buf);
 sr.es  = FP_SEG((void DOS_FAR *)buf);
 int86x(0x21, &r, &r, &sr);
 if (r.x.cflag & 1) goto Error;
#endif /*!defined(__BORLANDC__) && !defined(_MSC_VER)*/
/********************************************************************/
#elif 4 <= DOS_FAR_MODE && 6 >= DOS_FAR_MODE /* Watcom C32 */
 union   REGS  r;
 struct SREGS sr;
#pragma pack(1)
 struct {
         unsigned  long edi, esi, ebp, esp,
                        ebx, edx, ecx, eax;
         unsigned short flags;
         unsigned short es, ds, fs, gs;
         unsigned short ip, cs, sp, ss;
        } dr;
 unsigned short dos_seg, dos_sel;
#pragma pack()

 memset(&sr, 0, sizeof(sr));
 memset(&dr, 0, sizeof(dr));

 r.w.ax = 0x0100; /* DPMI: Allocate DOS memory */
 r.w.bx = bufsize + 15 >> 4;
 int386x(0x31, &r, &r, &sr);
 if (r.x.cflag & 1) goto Error;
 dos_seg = r.w.ax;
 dos_sel = r.w.dx;

 dr.eax = table | 0x6500; /* Prepare RealMode Int 21h */
 dr.ebx = ccp >> 16;
 dr.edx = ccp;
 dr.ecx = bufsize;
 dr.edi = 0;  /* Already memset(0) */
 dr.es = dos_seg;

 r.w.ax = 0x0300; /* DPMI: RealMode Int */
 r.w.bx = 0x21;
 r.w.cx = 0;
 r.x.edi = FP_OFF(&dr);
 sr.es = FP_SEG(&dr);
 int386x(0x31, &r, &r, &sr);
 if (r.x.cflag & 1) dr.flags = 1; /* Int Fail */
#if    !(3 & DOS_FAR_MODE) /* DOS/4GW ZeroBased */
 memcpy(buf, (void*)((long)dos_seg << 4), bufsize);
#else                      /* PharLap */
 _fmemcpy(buf, MK_FP(dos_sel, 0), bufsize);
#if      2 & DOS_FAR_MODE  /* PharLap + Buf-on-Stack */
 if (!(dr.flags & 1) &&
     table > 1 && bufsize >= offsetof(struct _dos_LCT_, t2.t))
   {
    unsigned long linear = LINEAR_FROM_FAR16((unsigned long)Buf->t);
    bufsize -= offsetof(struct _dos_LCT_, t2.t);
    Buf->t = &Buf->t2;
    _fmemcpy(&Buf->t2.size, MK_FP(0x34, linear), 2);
    _fmemcpy( Buf->t2.t,    MK_FP(0x34, linear + 2),
              Buf->t2.size < bufsize?
              Buf->t2.size : bufsize);
   }
#endif /*2 & DOS_FAR_MODE*/
#endif /*3 & DOS_FAR_MODE*/
 r.w.ax = 0x0101; /* DPMI: Free DOS memory */
 r.w.dx = dos_sel;
 int386x(0x31, &r, &r, &sr);

 if (dr.flags & 1) goto Error;
#if    !(2 & DOS_FAR_MODE)
 if (table > 1)
   {
#if      1 & DOS_FAR_MODE  /* PharLap + FAR pointer */
    Buf->t = MK_FP(0x34, LINEAR_FROM_FAR16((unsigned long)Buf->t));
#else                      /* DOS/4GW ZeroBased */
    Buf->t = (void*)LINEAR_FROM_FAR16((unsigned long)Buf->t);
#endif
   }
#endif /*!(2 & DOS_FAR_MODE)*/
/********************************************************************/
#elif 2 == DOS_FAR_MODE /* __DJGPP__ */
 __dpmi_regs r;
 r.h.al = table;
 r.h.ah = 0x65;
 r.x.bx = ccp >> 16;
 r.x.dx = ccp;
 r.x.cx = bufsize;
 r.x.di = __tb & 15;
 r.x.es = __tb >> 4;
 __dpmi_int(0x21, &r);
/* sr.es  = __tb >> 4; int86x(0x21, &r, &r, &sr); */
 if (r.x.flags & 1) goto Error;
 dosmemget(__tb, bufsize, buf);
 if (table > 1 && bufsize >= offsetof(struct _dos_LCT_, t2.t))
   {
    unsigned long linear = LINEAR_FROM_FAR16((unsigned long)Buf->t);
    bufsize -= offsetof(struct _dos_LCT_, t2.t);
    Buf->t = &Buf->t2;
    dosmemget(linear, 2, &Buf->t2.size);
    dosmemget(linear +2,  Buf->t2.size < bufsize?
                          Buf->t2.size : bufsize, Buf->t2.t);
   }
#endif /*DOS_FAR_MODE*/
/********************************************************************/
 return  0;
Error:
 return -1;
#undef  Buf
}
#endif /*!_Windows*/
/* end of doslocal.c */