/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

/* demonstrates buffer scaling the slow way and the fast way */
int main(void)
{
 image *pcx_pic;
 buffer_rec *buff,*buff2;
 int i,x1,y1,x2,y2;

 JLIB_DEBUG_OFF
 
 /* initialise screen sized buffer */
 buff = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);
 buff2 = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);

 /* load pcx */
 pcx_pic=image_load_pcx("demo9.pcx");

 /* check that load was OK */
 if(pcx_pic == NULL){
    jlib_exit("PCX load failed.");
 }
 
 /* set up the screen */
 if(!screen_set_video_mode()){
    jlib_exit("Screen Setup failed.");
 }

 screen_blank_pal();

 /* copy the image->buffer->screen */
 buff_blit_img_to(buff2,0,0,pcx_pic,0,0,IMG_MAX_X(pcx_pic),IMG_MAX_Y(pcx_pic));

 /* scale to full height - should look normal */
 buff_scale_full_buff_toNC(buff,0,0,SCREEN_MAX_X,SCREEN_MAX_Y,buff2);
 screen_blit_fs_buffer(buff);

 screen_fade_in_pal(IMG_PALETTE(pcx_pic),40);
 fgetc(stdin);

 /* show scaling smaller by increasing source size - slow method */
 x1=0;y1=0;x2=B_MAX_X(buff2);y2=B_MAX_Y(buff2);
 for(i=0;i<SCREEN_WIDTH/2;i++){
     x1-=2;x2+=2;y1--;y2++;
     buff_clear(buff);
     buff_scale_buff_to(buff,0,0,SCREEN_MAX_X,SCREEN_MAX_Y,buff2,x1,y1,x2,y2);
     screen_blit_fs_buffer(buff);
 }

 /* show scaling smaller by decreasing dest size - *much* faster */
 x1=0;y1=0;x2=B_MAX_X(buff);y2=B_MAX_Y(buff);
 for(i=0;i<SCREEN_WIDTH/4;i++){
     x1+=2;x2-=2;y1++;y2--;
     buff_clear(buff);
     buff_scale_buff_to(buff,x1,y1,x2,y2,buff2,0,0,B_MAX_X(buff2),B_MAX_Y(buff2));
     screen_blit_fs_buffer(buff);
 }
 
 screen_blank_pal();
 image_free(pcx_pic);

 /* return to text mode and exit */
 screen_restore_video_mode();
 return(0);
}
