/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <jlib.h>

#define RANDOM(u) ( rand() % ( ((u) + 1)  ) )

/* Note: This demo is not meant to test speed.  Its just a demo to show that 
** the simple primitives work.  In a real life situation you might well draw
** 10-15 rectangles,  20 points,  10 lines and a few circles before throwing
** the buffer out to the screen.  this demo draws 100 abitrarily- it doesnt
** *mean* anything.
*/

#define ITERATIONS 100

int main(void)
{
  int i=0,j,temp;
  buffer_rec *buff;
  UBYTE *pal;

  JLIB_DEBUG_OFF
  screen_set_video_mode();
  
  /* seed random number generator */
  srand((int)time(NULL)|1);

  /* initialise screen sized buffer */
  buff=buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);

  pal= pal_load("demo3.pal");
  
  if(pal == NULL){
     jlib_exit("Palette load failed.");
  }

  screen_block_set_pal(pal);
  
  /*********************/
  /* test line drawing */
  /*********************/
  buff_clear(buff);
   
  for(temp=0;temp!=100;temp++){
	for(j=0;j<ITERATIONS;j++){
           buff_draw_lineNC(buff,RANDOM(SCREEN_MAX_X), RANDOM(SCREEN_MAX_Y),
           RANDOM(SCREEN_MAX_X), RANDOM(SCREEN_MAX_Y), i = ++i % 255);
	}
	screen_blit_fs_buffer(buff);
  }
  
  fgetc(stdin);


  /**********************/
  /* test point drawing */
  /**********************/
  buff_clear(buff);

  for(temp=0;temp!=300;temp++){
	for(j=0;j<ITERATIONS;j++){
            buff_draw_pointNC(buff,RANDOM(SCREEN_MAX_X), RANDOM(SCREEN_MAX_Y),
	    i = ++i % 255);
	}    
	screen_blit_fs_buffer(buff);
  }

  fgetc(stdin);

  /*************************/
  /* test triangle drawing */
  /*************************/
  buff_clear(buff);

  for(temp=0;temp!=100;temp++){
	for(j=0;j<ITERATIONS;j++){
            buff_filled_triangle(buff,RANDOM(SCREEN_MAX_X), RANDOM(SCREEN_MAX_Y),
            RANDOM(SCREEN_MAX_X), RANDOM(SCREEN_MAX_Y),
            RANDOM(SCREEN_MAX_X), RANDOM(SCREEN_MAX_Y),i = ++i % 255);
	}    
	screen_blit_fs_buffer(buff);
  }

  fgetc(stdin);

  /**************************/
  /* test rectangle drawing */
  /**************************/
  buff_clear(buff);
      
  for(temp=0;temp!=100;temp++){
	for(j=0;j<ITERATIONS;j++){
            buff_draw_rectNC(buff,RANDOM(SCREEN_MAX_X), RANDOM(SCREEN_MAX_Y),
            RANDOM(SCREEN_MAX_X), RANDOM(SCREEN_MAX_Y),i = ++i % 255);
	} 
	    screen_blit_fs_buffer(buff);
  }

  fgetc(stdin);

  /************************/
  /* test ellipse drawing */
  /************************/
  buff_clear(buff);
     
  for(temp=0;temp!=100;temp++){
	for(j=0;j<ITERATIONS;j++){
            buff_draw_ellipseNC(buff,RANDOM(SCREEN_MAX_X)/2+SCREEN_MAX_X/4,
            RANDOM(SCREEN_MAX_Y)/2+SCREEN_MAX_Y/4, RANDOM(SCREEN_MAX_X)/4+1,
            RANDOM(SCREEN_MAX_Y)/4+1,i = ++i % 255);
	}    
	screen_blit_fs_buffer(buff);
  }

  fgetc(stdin);


  /******************************/
  /* test filled ellipse drawing */
  /******************************/
  buff_clear(buff);
     
  for(temp=0;temp!=100;temp++){
	for(j=0;j<ITERATIONS;j++){
            buff_filled_ellipseNC(buff,RANDOM(SCREEN_MAX_X)/2+SCREEN_MAX_X/4,
            RANDOM(SCREEN_MAX_Y)/2+SCREEN_MAX_Y/4, RANDOM(SCREEN_MAX_X)/4+1,
            RANDOM(SCREEN_MAX_Y)/4+1,i = ++i % 255);
	}    
	screen_blit_fs_buffer(buff);
  }

  screen_restore_video_mode();

  return(0);
}
