/**************************************************************
* TIMER1.C - this program calculates the execution time of    *
*   function testfunc().                                      *
*                                                             *
* To compile: "cl /Od /Fa /Gs timer1.c"                       *
* RHS 9/30/90																  *
**************************************************************/
#include<time.h>
#include<process.h>
#include<stdio.h>
#include<stdlib.h>

#define DEF_ITERATIONS   10000000L
#define TRUE 1
#define FALSE 0

int a, b = 3, c = 7;

int testfunc(int a, int b);
void cdecl main(int argc, char **argv);

/**************************************************************
* testfunc - the function whose execution time we are testing *
**************************************************************/
struct { int x, y; } pt ;

int testfunc(int dx, int dy)
  /* Adjust the pt by (dx,dy) and return */
  /* the quadrant of the point (x,y).    */
  {
    pt.x += dx;
    pt.y += dy;
    return( (pt.x & pt.y >= 0) ? 0 :
            (pt.x & pt.y < 0)  ? 2 :
            (pt.x < 0)         ? 1 : 3 );
  }

/**************************************************************
* main - calculates the execution time of the function        *
* testfunc which appears above.                               *
**************************************************************/
void cdecl main(int argc, char **argv)
    {
    long start = 0L, end = 0L;
    unsigned long iterations, setting =  DEF_ITERATIONS;
    unsigned def = FALSE;
    float test,empty,op;

    if(argc < 2)
        def = TRUE;
    else
        {
        if(!atol(argv[1]))
            def = TRUE;
        else
            setting = atol(argv[1]);
        }

    if(def)
        printf("Testing with default iterations: %lu\n",setting);
    else
        printf("Testing with %lu iterations\n",setting);

    puts("Testing code...");
    iterations = setting;
    start = clock();
    for( ; iterations; iterations--)
        c = testfunc(a,b);
    end = clock();
    test = (float)(end-start);
    test /= CLK_TCK;

    printf("Test end:\n");
    printf(" Function test required: %04.2f seconds\n", test);
    printf("   Test function took: %04.2f uSecs. per iteration\n",
           test*(1E6/setting));
    }
