/* skipsp.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"skipsp.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(skipsp)
#endif

// skipsp() -- Skip leading white space.
//  char * skipsp(const char * const); 
// GIVEN:
//	p_str	pointer to string.
// RETURNS: (r8)
//	pointer to the first non white space character in the string.
//	pointer to the terminating '\0' if no non white space chars in string.
// NOTES:
//  see isspace for a definition of a white space character.
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(skipsp)
ilibc_64_proc_prologue
ilibc_64_proc_body
p_str==r32
ret_ptr==r8
tmp==r11
	mov ret_ptr=p_str
Loop:
	ld1 tmp=[ret_ptr],1
	cmp.eq p30,p31=0x20,tmp
	(p30) br.cond.spnt Loop
	cmp.gtu p30,p31=0x09,tmp
	(p30) br.cond.spnt Done
	cmp.geu p30,p31=0x0D,tmp
	(p30) br.cond.spnt Loop
Done:
	sub ret_ptr=ret_ptr,r0,1	// --ret_ptr
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(skipsp)
