/* ilibc_64.inc, ilibc_64.lib */
/* Byron Young, 2002 */

#ifndef ilibc_64_inc
#define ilibc_64_inc


// for use in .prologue imm-mask
PROLOGUE_SAVE_RP==0b1000
PROLOGUE_SAVE_AR_PFS==0b0100
PROLOGUE_SAVE_PSP==0b0010
PROLOGUE_SAVE_PRED==0b0001

// for use in procedure setup
#define ilibc_64_proc_start(fn_name)	.align 16		; \
					.global fn_name#	; \
					.proc fn_name#		; \
				fn_name:			;

#define ilibc_64_proc_body		.body

#define ilibc_64_proc_prologue		.prologue

#define ilibc_64_proc_epilogue

#define ilibc_64_proc_end(fn_name)	.endp fn_name#

// for use in optional external pointer setup
#define ilibc_64_extern_ptrs_define(pt_name) ; \
       ILIBC_64_EXTERN_PTRS_SECTION_NAME ; \
       .global p_fn_##pt_name# ; \
       .align 8 ; \
       p_fn_##pt_name#:  data8 @fptr(pt_name#) ;

// for use in generating "extern" procedure
#define ilibc_64_proc_extern(fn_name) .global fn_name# ; \
                          .type fn_name#, @function;

#define ilibc_64_proc_ptrs_extern(fn_name) .global p_fn_##fn_name# ; \
                          .type p_fn_##fn_name#, @object; \
                          .size p_fn_##fn_name#, 8 ;
#include "ilibc_64/ilibc_64.h"

#endif /* #ifndef ILIBC_64_INC */




