/* ilibc_64.h, ilibc_64.lib */
/* Byron Young, 2002 */

#ifndef ILIBC_64_H
#define ILIBC_64_H

/*
*
* EXPECTED DEFINED MACROS
* NOTE:
*   if none of the following are defined, defaults to:
*	DEBUG_YES, ILIBC_64_EXTERN_PTRS_NO,
*	ILIBC_64_PROCEDURE_SECTION_NAME .text,
*       ILIBC_64_EXTERN_PTRS_SECTION_NAME .data.
*
* DEBUG - Determines if some debug info is generated.
*		     DEBUG_NO=0
*		     DEBUG_YES=1 (Default)
* ILIBC_64_PROCEDURE_SECTION_NAME - name of procedure code segment.
*		     Defaults to .text
*                    if not defined on entry, defaults to .text (normal usage)
*                    if defined on entry, assumed to be other than .text
*                      and causes section __attribute__ to be defined.
* ILIBC_64_EXTERN_PTRS - If generate pointers to functions
*		     ILIBC_64_EXTERN_PTRS_NO=0 (Default)
*		     ILIBC_64_EXTERN_PTRS_YES=1
* ILIBC_64_EXTERN_PTRS_SECTION_NAME - Data section name for pointers.
*		     Defaults to .data
*                    If not defined on entry, defaults to .data (normal usage)
*                    If defined on entry, assumed to be other than .data
*                      and causes section __attribute__ to be defined.
*/

/* some values */
#ifndef DEBUG_YES
# define DEBUG_YES 1
#endif

#ifndef DEBUG_NO
# define DEBUG_NO 0
#endif

#ifndef ILIBC_64_EXTERN_PTRS_NO
# define  ILIBC_64_EXTERN_PTRS_NO 0
#endif

#ifndef ILIBC_64_EXTERN_PTRS_YES
# define  ILIBC_64_EXTERN_PTRS_YES 1
#endif

/* stringizing substitution macros */
#ifndef stringeyes_x
# define stringeyes_x(aabb) #aabb
#endif

#ifndef stringeyes
# define stringeyes(bbaa) stringeyes_x(bbaa)
#endif

/* defaults */
#ifndef DEBUG
# define DEBUG DEBUG_YES
#endif

#ifndef ILIBC_64_EXTERN_PTRS
# define ILIBC_64_EXTERN_PTRS ILIBC_64_EXTERN_PTRS_NO
#endif

#ifndef ILIBC_64_PROCEDURE_SECTION_NAME
  /* normal situation */
# define ILIBC_64_PROCEDURE_SECTION_NAME .text
# define ilibc_64_code_section
#else
  /* defined a different section name */
# define ilibc_64_code_section __attribute__ ((section(stringeyes(ILIBC_64_PROCEDURE_SECTION_NAME)))
#endif

#ifndef ILIBC_64_EXTERN_PTRS_SECTION_NAME
# define ILIBC_64_EXTERN_PTRS_SECTION_NAME .data
# define ilibc_64_extern_ptrs_section __attribute__ ((section(stringeyes(ILIBC_64_EXTERN_PTRS_SECTION_NAME)))
#else
# define ilibc_64_extern_ptrs_section
#endif

#endif /* ILIBC_64_H */


