### this is the default makefile, DEFAULT.MK

SUFFIXES = .exe .o .obj .c .asm .l .y .ec .h .bat
.SUFFIXES : $(SUFFIXES)

#	ASM section
AS	 = masm
ASFLAGS	 =
COMPILE.s= $(AS) $(ASFLAGS)
COMPILE.S= $(AS) $(ASFLAGS)
.asm.exe :
	 $(COMPILE.s) $<;
	 $(LINK.c) -o $@ $*.obj
	 $(RM) $*.obj
.asm.obj :
	 $(COMPILE.s) $<;
.asm.o	 :
	 $(COMPILE.s) $<;
	 mv $*.obj $*.o

#	C section
CC	 = cl -A$(MODEL)
CFLAGS	 = -Ox
CPPFLAGS =
COMPILE.c= $(CC) $(CFLAGS) $(CPPFLAGS) -c
.c.exe	 :
	 $(LINK.c) -o $@ $<
	 $(RM) $*.obj
.c.o	 :
	 $(COMPILE.c) /Fo$*.o $<
.c.obj	 :
	 $(COMPILE.c) $<

#	D section (ANSI C declaration headers)
.c.d	 :
	 echo #ifndef NOPROTOTYPES > $*.tmp
	 $(CC) -DNOPROTOTYPES -Zg $< >> $*.tmp
	 echo #endif >> $*.tmp
	+updexhdr $*.tmp $*.d
	 $(RM) $*.tmp

#	ESQL/C section
ESQL	 = esql
EFLAGS	 =
COMPILE.e= $(ESQL) $(EFLAGS)
.ec.exe	 :
	 $(COMPILE.e) -e $<
	 $(LINK.c) -o $@ $*.c
	 $(RM) $*.obj $*.c
.ec.o	 :
	 $(COMPILE.e) -e $<
	 $(COMPILE.c) /Fo$*.o $*.c
	 $(RM) $*.c
.ec.obj	 :
	 $(COMPILE.e) -e $<
	 $(COMPILE.c) $*.c
	 $(RM) $*.c
.ec.c	 :
	 $(COMPILE.e) -e $<

#	Lex section
LEX	 = flex
LFLAGS	 = -I
LEX.l	 = $(LEX) $(LFLAGS) -t
.l.exe	 :
	 $(LEX.l) $< > $*.c
	 $(LINK.c) -o $@ $*.c
	 $(RM) $*.obj $*.c
.l.c	 :
	 $(LEX.l) $< > $@
.l.o	 :
	 $(LEX.l) $< > $*.c
	 $(COMPILE.c) /Fo$*.o $*.c
	 $(RM) $*.c
.l.obj	 :
	 $(LEX.l) $< > $*.c
	 $(COMPILE.c) $*.c
	 $(RM) $*.c

#	YACC Section
YACC	 = bison
YFLAGS	 =
YACC.y	 = $(YACC) $(YFLAGS)
.y.exe:
	 $(YACC.y) $<
	 $(LINK.c) -o $@ $*.c
	 $(RM) $*.obj $*.c
.y.h:
	 $(YACC.y) -d -y $<
	 $(RM) ytab.c
	 $(MV) ytab.h $@
.y.c:
	 $(YACC.y) $<
.y.o:
	 $(YACC.y) $<
	 $(COMPILE.c) /Fo$*.o $*.c
	 $(RM) $*.c
.y.obj:
	 $(YACC.y) $<
	 $(COMPILE.c) $*.c
	 $(RM) $*.c

#	Misc section
AR	 = lib
LDFLAGS  = /link /noe /noi
LINK.c	 = $(CC) $(CFLAGS) $(CPPFLAGS)
LD	 = $(LINK.c)
MAKE	 = make
MKDEPEND = mkdepend
MODEL	 = S
MV	 = mv
RM	 = rm -f

BIN      =c:\bin
LIB      =e:\msc5.1\lib

#.o.exe	 :
#	 link $*.o $(LIB)\setargv.obj $(LDFLAGS) /NOE/NOI;
#.obj.exe :
#	 link $*.obj $(LIB)\setargv.obj $(LDFLAGS) /NOE/NOI;
