/* header file for example 4, see ex4.c
   It is not necessary to put this stuff into a seperate file, it is simply
   intended to increase readability.
 */

#ifndef __FLAT_H
#include "../flat.h"
#endif

/* Information about a desired video mode. Only those important for this
   example are included!
 */
typedef struct
  {

    /* width of screen */
    unsigned width:12;

    /* and height */
    unsigned height:12;

    /* number of bits per pixel */
    unsigned bits_per_pixel:5;

    /* flag whether linear framebuffer available. If not, all this is
       pretty useless :-(
     */
    int framebuf_avail:1;

    /* flat pointer to the video memory */
    flatptr vidmem;
  }
VESA_MODE_INFO;

/* this variable contains the information about the video mode we use */
VESA_MODE_INFO vmi;

/* this flag can be ORed to the video mode to enable the linear
   framebuffer
 */
#define VESA2_LINEAR ((unsigned)(1<<14))

/* the maximum color value used by the plasma writing function */
#define MAX_PAL 192

/* the video mode used (640x480x256) */
#define VIDEO_MODE 0x101

/* the cloud density of the plasma */
#define DENSITY 2.0

void errexit (const char *,...);
int bget_key (void);
int bkey_pressed (void);
void set_video_mode (int m);

int get_vesa_info (void);
int get_vesa_mode_info (int mode, VESA_MODE_INFO * vmi);
int set_vesa_mode (int mode);

void put_pixel (int x, int y, int c);
int get_pixel (int x, int y);

void set_pal (char *p);
void vsync (void);
void rotate_pal (void);
void setup_pal (void);

void init_plasma (void);
void split_box (int x1, int y1, int x2, int y2);
