#include <stddef.h>
#include <msmouse.h>
#include <fg.h>

#ifndef __FE_H
#define __FE_H

#define min( x, y ) ( ( x ) < ( y ) ? ( x ) : ( y ) )
#define max( x, y ) ( ( x ) > ( y ) ? ( x ) : ( y ) )

class win ;

typedef void ( win :: *eventscript_t )() ;

class boxes {

	public :
		boxes ( size_t ) ;

		~boxes () {
			delete comd ;
			delete comdscripts ;
		}

		void add_script ( fg_pbox_t, eventscript_t ) ;

		void translate_script ( win *, fg_coord_t, fg_coord_t ) ;

	private :
		fg_pbox_t *comd ;
		eventscript_t *comdscripts ;
		size_t size ;
		size_t point ;
} ;

class keyboard {

	public :
		keyboard ( size_t ) ;

		~keyboard () {
			delete comd ;
			delete comdscripts ;
		}

		void add_script ( char, eventscript_t ) ;

		void translate_script ( win *, char ) ;

	private :
		char *comd ;
		eventscript_t *comdscripts ;
		size_t size ;
		size_t point ;
} ;

class win {

	public :
		win ( fg_coord_t _x, fg_coord_t _y, fg_coord_t _w,
			fg_coord_t _h, fg_color_t _fg, fg_color_t _bg,
			win *_p, size_t _ks, size_t _bs ) :
			x( _x ), y( _y ), height( _h ), width( _w ),
			fgc( _fg ), bgc( _bg ), parent( _p ), quit( 0 ),
			activate_key( '\x0' ) {

			if ( parent ) {
				x += parent->x ;
				y += parent->y ;
			}

			fg_make_box( winbox, x, y, x + width - 1,
				y + height - 1 ) ;
			kbd = new keyboard( _ks ) ;
			box = new boxes( _bs ) ;
		}
		~win () { delete kbd ; delete box ; }
			
		virtual void expose () = 0 ;
		virtual void focus () = 0 ;
		virtual void destroy () = 0 ;

		void cls () {
			fg_fillbox( bgc, FG_MODE_SET, ~0, winbox ) ;
		}
		void clear () {
			fg_fillbox( FG_BLACK, FG_MODE_SET, ~0, winbox ) ;
		}
		void focus_loop ( win * ) ;
		void expose_parent () { if ( parent ) parent->expose() ; }

		void add_script ( fg_box_t b, eventscript_t s ) {
			box->add_script( b, s ) ;
		}
		void add_script ( char k, eventscript_t s ) {
			kbd->add_script( k, s ) ;
		}

	protected :
		fg_coord_t x, y, height, width ;
		fg_color_t fgc, bgc ;
		win *parent ;
		fg_box_t winbox ;
		keyboard *kbd ;
		boxes *box ;
		int quit ;
		char activate_key ;
} ;

class editmap ;

class menu : public win {

		friend editmap ;

	public :
		menu ( fg_coord_t, fg_coord_t, size_t, size_t, win * ) ;
		~menu () { delete i_names ; }

		void add_item ( char, char *, eventscript_t ) ;

		void expose () ;
		void focus () ;
		void destroy () ;

	private :
		char **i_names ;
		size_t point, size ;
} ;

#endif
