#include "fe.h"

#ifndef __BMP_H
#define __BMP_H

class editmap : public win {

	public :
		editmap ( int, int, char * ) ;
		~editmap () ;

		void edit_map () ;
		void total_map () ;

		void expose() ;
		void focus() ;
		void destroy() ;

		void copymap ( char ** ) ;

	private :
		static const char mode_s ;
		static const char mode_x ;
		static const char *mode_str ;

		void getmspos () ;
		void finish_func () { pix[FG_X1] = pix[FG_X2] = -1 ; }
		void translate () ;
		void drawcell ( int, int, int ) ;
		void redraw ( int, int, int, int ) ;
		void floodfill() ;
		void invert_box () ;
		void draw_line () ;
		void draw_pixel () ;
		void draw_circle () ;
		void draw_ellipse () ;
		void draw_box () ;
		void flip_x () ;
		void flip_y () ;
		void clear () ;
		void copy () ;
		void cut () ;
		void paste () ;

		fg_color_t get_color () ;
		int get_mode () ;
		void set_mode () ;
		void byebye () ;
		void save () ;
		void _redraw () ;
		void _set_invert_box () ;
		void _set_draw_pixel () ;
		void _set_draw_line () ;
		void _set_floodfill () ;
		void _set_draw_circle () ;
		void _set_draw_ellipse () ;
		void _set_draw_box () ;
		void _set_clear () ;
		void _set_copy () ;
		void _set_cut () ;
		void _set_paste () ;
		void _set_flip_x () ;
		void _set_flip_y () ;
		void set_funcname ( eventscript_t, char * ) ;
		void delete_array ( char **, int ) ;
		char **alloc_array ( int, int ) ;
		void realloc_array ( char ***, int, int ) ;

		fg_box_t cellbox ;
		char **bits, *mode, *func, *filename, **clipb ;
		unsigned p_x, p_y ;
		int w, h, p_status, clip_w, clip_h ;
		fg_box_t editbox, dispbox, pix ;
		eventscript_t draw_func ;
		menu *mu ;
} ;

#endif
