
/* wrchar.c  EOUE Project, 1997 by Michael Mangelsdorf   */
/* THIS FILE IS PUBLIC DOMAIN.
   LEAVE THIS MESSAGE IN PLACE AS COURTESY TO THE AUTHOR */


#include <stdio.h>
#include <dos.h>

typedef unsigned char  byte;

extern byte *font8x8ptr, *font8x16ptr, /* VGA ROM fonts*/
	    *joyo_font, *kana_font;    /* See LOADFONT.C for font info*/

extern unsigned x,y,wpage; /* See definitions in VGA.C. */
extern byte c;
extern byte pal [256][3];
extern byte vpage;


/* Draw ROM ASCII character
*/
void wrchar_ROM (unsigned x0, unsigned y0, byte uchar, byte bg, byte h) {
byte i,k;
byte bitmap;
byte *pixelbyte;
  pixelbyte=h?(font8x16ptr+16*uchar):(font8x8ptr+8*uchar);
  for (i=0; i<(h?16:8); i++)  {
       bitmap=*(pixelbyte++);
       for (k=0;k<8;++k,bitmap<<=1)
	  if (bg?!(bitmap&128):(bitmap&128)) {
	     x=x0+k; y=y0+i;
	     plot();
	  }
 }
}

/* Draw either kana or kanji character bitmap.
   'uchar' 0-1945 are joyo, 2000 upwards are kana.
*/
void wrchar_JIS (unsigned x0, unsigned y0, unsigned uchar, byte bg) {
 byte i,k;
 unsigned bitmap;
 byte *pixelbyte;

 if (uchar<1945) pixelbyte=joyo_font+32*uchar;
 if ((uchar>1944)&&(uchar<2000)) return;
 if (uchar>1999) pixelbyte=kana_font+32*(uchar-2000);

 for (i=0; i<16; i++) {
      bitmap=*(pixelbyte++)<<8;
      bitmap+=*(pixelbyte++);
      bitmap=~bitmap;
      for (k=0;k<16;++k,bitmap<<=1) {
	  if (bg?!(bitmap&32768):(bitmap&32768)) {
	     x=x0+k; y=y0+i; plot();
	  }
      }
 }
}


/* Draw string of ASCII characters
*/
void fixprint (unsigned col, unsigned line, char *s, byte bg, byte height) {
 byte i,j;
  j=strlen(s);
  for (i=0;i<j;i++)
    wrchar_ROM (col+i*8,line,s[i],bg,height);
}


/* Draw string of two-byte Japanese characters.
*/
void jprint (unsigned col, unsigned line, unsigned *codestr, byte bg) {
  byte i;
  if (codestr==NULL) return;
  for (i=1;i<codestr[0];i++) wrchar_JIS (col+(i-1)*16,line,codestr[i],bg);
}


/* Same as jprint, but vertically
*/
void tategaki (unsigned col, unsigned line, unsigned *codestr, byte bg) {
  byte i;
  if (codestr==NULL) return;
  for (i=1;i<codestr[0];i++) wrchar_JIS (col,line+(i-1)*18,codestr[i],bg);
}


