
/* cmdline.c  1997 by Michael Mangelsdorf

   This is a crude emergency implementation for a command-line
   interface using EOUE.

   THIS FILE IS PUBLIC DOMAIN.
   LEAVE THIS MESSAGE IN PLACE
     AS COURTESY TO THE AUTHOR
*/


#include <stdio.h>

typedef unsigned char  byte;

extern byte c; /* global variable: color for subsequent graphics */


/* Prints either an ASCII string or a Japanese string (of unsigneds.)
   Either 'what_a' or 'what_j' MUST be NULL. 'scroll' enables/disables
   scrolling. Pos is the starting pixel column, a multiple of 8 for
   ROM-font characters or 16 for Japanese characters!

   If cmdl_out() is called with scroll set to false, no screen-swapping
   takes place - the bottom line will not be visible until you either
   call flipscreen() or cmdl_out() with argument 'scroll' set to true!
*/
void cmdl_out (char* what_a, unsigned* what_j, byte pos, byte scroll) {
 if (what_j==NULL) fixprint (pos*8,360,what_a,0,1);
 else jprint (pos*16,360,what_j,0);
 if (scroll) { c=0; flipscreen(); chunkscroll_up (1); c=15; flipscreen(); }
}


/* Puts a prompt symbol on bottom of screen
   and reads in an input line.
*/
char* cmdl_in (char* buffer) {
 byte pos=0, max=0, i;
 unsigned key;
 c=15; buffer[0]=0;
 while (1) {
    fixprint (0,360,buffer,0,1);
    if (max) {
	  wrchar_ROM (pos*8,360,buffer[pos],1,1);
     c=2; wrchar_ROM (pos*8,360,buffer[pos],0,1); c=15;
    }
    else wrchar_ROM (0,360,255,1,1);
    flipscreen();
    while (bioskey(1)==0) ;
    key=bioskey(0);
      c=0; wrchar_ROM (pos*8,360,buffer[pos],1,1); c=15;
	   wrchar_ROM (pos*8,360,buffer[pos],0,1);
    if (pos&&key==0x1C0D) break;
    if (pos&&key==0x0E08) {  /*BS*/
       pos--; for (i=pos;i<max;i++) buffer[i]=buffer[i+1];
       max--;
    }
    if ((pos<max)&&key==0x5300) {  /*DELC*/
       for (i=pos;i<max;i++) buffer[i]=buffer[i+1]; max--;
    }
    if (key==0x4B00) if (pos) pos--;
    if (key==0x4D00) if (pos<max) pos++;
    if ((max<40)&&isalnum(key&0xFF)) {
       max++; for (i=max;i>pos;i--) buffer[i]=buffer[i-1];
       buffer[pos]=(key&0xFF); pos++;
    }
    c=0; linedel (360,20); c=15;
 }
  c=0; flipscreen(); chunkscroll_up (1); c=15; flipscreen();
}
