#
# opusgraf.awk - makes a histogram of Opus BBS caller usage 
#

BEGIN { # get the bbs name from the command line
        bbs_name = ARGV[ARGC - 1]
      
	# then null it out so it wont be interpreted as a file name
		ARGV[ARGC - 1] = ""

	# initialize an array with entries for each half-hour
        # period
	      for(hour = 0;hour < 24;hour++) {
              hour = (length(hour) < 2) ? ("0" hour) : hour
              for(min = "00";min < 60;min += 30)
	   	humans[hour ":" min] = 0;
  			}
			}

# we're only interested in callers
/calling/ {
      	 # some log entries have a blank first field, so
      	 # we have to compensate
      		 if ($4 ~ /:/)   
            		fld = 4
	    		 else
	    		fld = 3

	 # save the first and last dates
		 if (startdate == "")
			startdate = $(fld - 1) " " $(fld - 2)
			 else
			enddate = $(fld - 1) " " $(fld - 2)

       	 # process the hour entry, remove ":" if necessary and
       	 # pad with 0's 
       		 hour = substr($fld,1,2)
                	 if (sub(":","",hour))
  			  hour = (length(hour) < 2) ? ("0" hour) : hour

       	 # process the minutes entry, rounding off at half-hour intervals
       		 min  = substr($fld,4,2)
       			 if (min < 30)
       				min = 0
       				 else
       				min = 30

       	 # assemble the index string 
       		 timestring = hour ":" ((min == 0) ? "00" : min)
						 
       	 # increment the value
       		 humans[timestring]++
       				}


END { 
	   # put the name of the BBS on the command line
             printf("Stats for %s from %s to %s\n\n",bbs_name,startdate,enddate)

	   # generate the histogram
	     for(time in humans) {
	     	printf("%s\t%s\n",time,rep(humans[time],"*"))
		 }
    }

function rep(n,s,   t) {
 while(n-- > 0)
	t = t s
 return t
}
