/* setattr.c */


/* Sets a file's archive bit either on or off */
/* Compiled under Turbo C V. 1.5 */

#define ARCH_ON	0x20   /* set archive bit in attribute byte */
#define ATTR_OFF	0x00   /* clear entire attribute byte */
#define RD_ONLY	0x01	 /* set read-only bit */
#define SYSTM		0x04   /* set system file bit */
#define HIDDN		0x02   /* set hidden file bit */

#define GET			0      /* used with _chmod to read a file's
								    attribute byte */
#define SET		   1      /* used with _chmod to set a file's
									 attribute byte */

#include "stdio.h"
#include "io.h"



main (argc, argv)
int argc;
char *argv[];
{
if (argc != 3) {
	printf("Format: SETATTR ON <filename> or SETATTR OFF <filename>\n");
					}

/* set the file's archive bit */

if (strcmp(argv[1], "ON") == 0 || strcmp(argv[1], "on") == 0) {
	_chmod(argv[2], SET, ARCH_ON);
	printf("\nArchive Bit for %s has been set ON.\n", argv[2]);
             																	}
/* clear the file's archive bit (as well as it's read-only bit, etc.) */

if (strcmp(argv[1], "OFF") == 0 || strcmp(argv[1], "off") == 0) {
	_chmod(argv[2], SET, ATTR_OFF);
	printf("\nArchive Bit for %s has been set OFF.\n", argv[2]); }

}

/* This little program uses the _chmod function defined in io.h
	to set or release a file's archive bit.  The _chmod function
	can also be used to set other file attributes, such as read-only,
	hidden, system file, etc. (see #define's above).  More than one
	attribute can be set at a time by ORing the masks together.  For
	example, to set a file's archive and read-only bits on you could
	use: _chmod("filename", SET, 0x20|0x01).  If _chmod's second
	argument is set to 0 (or GET using the #define above), it will
	return the current file attribute instead of setting it:

	int attrib;

	attrib = _chmod("filename", GET, 0x20);

	When using _chmod to read a file's attribute byte, you must
	include the third argument but it really does not do anything.
	The file's attributes can be represented in decimal as follows:

	Bit          Value              Meaning

	0					1						Read-only file
	1					2						Hidden File
	2					4						System File
	3					8						Volume Label Name
	4				  16						Subdirectory Name
	5				  32						Archive
	6				  64						Unused
	7			    128						Unused

	The preceding table was taken from Turbo C - The Complete
	Reference by Herbert Schildt, Page 236.

*/