#if !defined(__DOS_H)
#define __DOS_H

#ifndef __DEFS_H__
#include <defs.h>
#endif
#define FA_NORMAL   0x00        /* Normal file, no attributes */
#define FA_RDONLY   0x01        /* Read only attribute */
#define FA_HIDDEN   0x02        /* Hidden file */
#define FA_SYSTEM   0x04        /* System file */
#define FA_LABEL    0x08        /* Volume label */
#define FA_DIREC    0x10        /* Directory */
#define FA_ARCH     0x20        /* Archive */

#define _A_NORMAL   0x00        /* Normal file, no attributes */
#define _A_RDONLY   0x01        /* Read only attribute */
#define _A_HIDDEN   0x02        /* Hidden file */
#define _A_SYSTEM   0x04        /* System file */
#define _A_VOLID    0x08        /* Volume label */
#define _A_SUBDIR   0x10        /* Directory */
#define _A_ARCH     0x20        /* Archive */

#define SEEK_CUR    1
#define SEEK_END    2
#define SEEK_SET    0

struct  dfree
{
    unsigned df_avail;
    unsigned df_total;
    unsigned df_bsec;
    unsigned df_sclus;
};

struct diskfree_t
{
    unsigned total_clusters;
    unsigned avail_clusters;
    unsigned sectors_per_cluster;
    unsigned bytes_per_sector;
};

struct time
{
    unsigned char   ti_min;     /* Minutes */
    unsigned char   ti_hour;    /* Hours */
    unsigned char   ti_hund;    /* Hundredths of seconds */
    unsigned char   ti_sec;     /* Seconds */
};

struct date
{
    int     da_year;        /* Year - 1980 */
    char    da_day;     /* Day of the month */
    char    da_mon;     /* Month (1 = Jan) */
};

struct dostime_t
{
    unsigned char hour;         /* Hours */
    unsigned char minute;       /* Minutes */
    unsigned char second;       /* Seconds */
    unsigned char hsecond;      /* Hundredths of seconds */
};

struct dosdate_t
{
    unsigned char day;      /* 1-31 */
    unsigned char month;    /* 1-12 */
    unsigned int  year;     /* 1980 - 2099 */
    unsigned char dayofweek;/* 0 - 6 (0=Sunday) */
};

/* I will reorganize this properly later, do, don't depend on the size
 * field for now.  And DON'T depend on ordering of fields either
 */
struct find_t
{
    unsigned char   reserved[21];
    unsigned char   attrib;            /* attribute byte for matched file */
    unsigned short  wr_time;           /* time of last write to file */
    unsigned short  wr_date;           /* date of last write to file */
    unsigned short  size[2];           /* size of file */
    char            name[13];         /* asciiz name of matched file */
    char	    uu[256];
};

extern  unsigned char    _osmajor;
extern  unsigned char    _osminor;

#ifdef __cplusplus
extern "C" {
#endif

unsigned   _RTL_NORM _dos_getdiskfree(unsigned __drive,
                                                struct diskfree_t *__dtable);
int        _RTL_NORM _dos_getdrive(int *drive) ;
int        _RTL_NORM _dos_setdrive(int drive, int *ndrives);
void       _RTL_NORM _dos_getdate(struct dosdate_t *__datep);
unsigned   _RTL_NORM _dos_getfileattr(const char *__filename,
                                                unsigned *__attrib);

unsigned   _RTL_NORM _dos_getftime(int fd, unsigned short *date, unsigned short *time);
int        _RTL_NORM _dos_getpwd(char *buf, int drive) ;
void       _RTL_NORM _dos_gettime(struct dostime_t *__timep);
unsigned   _RTL_NORM _dos_setdate(struct dosdate_t *__datep);
unsigned   _RTL_NORM _dos_setfileattr(const char *__filename,
                                                unsigned __attrib);
int        _RTL_NORM _dos_setpwd(char *buf) ;
unsigned   _RTL_NORM _dos_settime(struct dostime_t *__timep);
int        _RTL_NORM _dos_findfirst(char *string, int attr, struct find_t *buf) ;
int        _RTL_NORM _dos_findnext(struct find_t *buf) ;
unsigned   _RTL_NORM _dos_open(char *name,int mode, int *fd);
unsigned   _RTL_NORM _dos_close(int fd);
unsigned   _RTL_NORM _dos_setftime(int fd, unsigned short date, unsigned short time);
unsigned   _RTL_NORM _dos_creat(const char *__pathP, unsigned __attr,
                                          int *__fd);
unsigned   _RTL_NORM _dos_creatnew(const char *__pathP, unsigned __attr,
                                             int *__fd);
void       _RTL_NORM disable(void);
void       _RTL_NORM enable(void);
void       _RTL_NORM getdfree(unsigned char __drive,
                                        struct dfree *__dtable);
int        _RTL_NORM _getdrive(void);
long       _RTL_NORM dostounix(struct date *__d, struct time *__t);
void       _RTL_NORM unixtodos(long __time, struct date *__d,
                                         struct time *__t);
int        _RTL_NORM unlink(const char *__path);
unsigned   _RTL_NORM _dos_read(int __fd, void *__buf, unsigned __len,
                                         unsigned *__nread);
unsigned   _RTL_NORM _dos_write(int __fd, const void *__buf, unsigned __len,
                                          unsigned *__nread );
void       _RTL_NORM getdate(struct date *__datep);
void       _RTL_NORM gettime(struct time *__timep);
void       _RTL_NORM setdate(struct date *__datep);
void       _RTL_NORM settime( struct time *__timep);
int        _RTL_NORM bdos(int func, unsigned regdx, int regal);

int        _RTL_NORM sleep(int __seconds) ;

#ifdef __cplusplus
};
#endif

#define _disable()      _genbyte((unsigned char)(0xfa)) /* MSC name */
#define disable()       _genbyte((unsigned char)(0xfa)) /* MSC name */
#define _enable()       _genbyte((unsigned char)(0xfb)) /* MSC name */
#define enable()        _genbyte((unsigned char)(0xfb)) /* MSC name */
#define geninterrupt(i) _genbyte(0x21); _genbyte(i)      /* Interrupt instruction */

extern int        _RTL_NORM _argc ;
extern char **    _RTL_NORM _argv ;
#define __argc    _argc
#define __argv    _argv

#define MK_FP(__s,__o) ((void _far *)(((void _seg *)(__s)) + ((void _near *)(__o))))
#define _MK_FP(__s,__o)  MK_FP(__s,__o)

#define FP_SEG(__p)  ((unsigned)(void _seg *)(__p))
#define _FP_SEG(__p) ((unsigned)(void _seg *)(__p))

#define FP_OFF(__p)  ((unsigned)(__p))
#define _FP_OFF(__p) ((unsigned)(__p))

#endif /* __DOS_H */