/*------------------------------------------------------------------------*
 *  File: demo.c							  *
 *  Author: Brady Tippit						  *
 *  Compiler: Borland (C++ 4.5, SMALL memory model, and Borland keywords) *
 *									  *
 *  This driver file exercises some of the td.lib functions.		  *
 *									  *
 *------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include "datelib.h"




void DisplayFormats(void);
void example1(void);
void example2(void);
void example3(void);

void main(void)
{   

   clrscr();
   printf("\n\n\n\t\tHere are a few simple examples of how td.lib\n");
   printf("\t\tcan be used... ");
   sleep(6);
   clrscr();
   example1();
   example2();
   example3();
   DisplayFormats();
  
   
}


void example1(void)
{
  tdtype *date;
  int month, day, year;
  char output[80]; 
  long int numOfdays, daysToAdd;

  printf("\n\n\n\t\tOne common use is: given a date and some number\n");
  printf("\t\tof days, find the calendar date for that many days\n");
  printf("\t\ttaking any leap years into account and going either\n");
  printf("\t\tforward or backward in time.  ");
  sleep(13);
  clrscr();
  
  date = CreateDate();

  printf("\n\n\n\tEnter a month, day, year, (for example 1 10 1965)...  ");  
  scanf("%d%d%d", &month, &day, &year);
  
  if( LoadDate(date, month, day, year) == -1 )
  {
    fprintf(stderr, "\nInvalid date!\n");
    exit(1);
  }
  
  numOfdays = DateToDays(date);
  
  printf("\n\tEnter a positive number of days to go forward in\n");
  printf("\ttime or a negative number to go backward in time... ");
  scanf("%ld", &daysToAdd);

  numOfdays += daysToAdd;

  if( DaysToDate(date, numOfdays) == -1 )
  {
    fprintf(stderr, "\nInvalid date!\n");
     exit(1);
  }

  TDFormat(date, output, 80, "%r");

  if(daysToAdd < 0)
  {
    daysToAdd *= -1L;
    printf("\n\t\t%ld days before, the date was:  %s\n", daysToAdd, output);
  }
  else
  printf("\n\t\t%ld days later, the date will be:  %s\n", daysToAdd, output);
  
  PrintCalendar(date->td_mon, date->td_year);

  FreeDate(&date);

  cprintf("\r\n\r\n\r\n\r\n   Press any key to continue... ");
  while (!kbhit())
   ;
  getch();
  clrscr();
}


void example2(void)
{
   tdtype *date1, *date2;   
   int mon1, day1, year1, mon2, day2, year2; 
   long int numOfdays;

   printf("\n\n\n\t\tThis can also be done in reverse:\n");
   printf("\t\tgiven two dates, find the number of days\n");
   printf("\t\tbetween them. ");
   sleep(7);
   clrscr();

   date1 = CreateDate();
   date2 = CreateDate();

   printf("\n\n\n\t\tEnter the first date's month, day, and year... ");
   scanf("%d%d%d", &mon1, &day1, &year1);
   
   if( LoadDate(date1, mon1, day1, year1) == -1 )
   {
     fprintf(stderr, "\nInvalid date!\n");
     exit(1);
   }
   
   printf("\n\t\tEnter the second date's month, day, and year... ");
   scanf("%d%d%d", &mon2, &day2, &year2);

   if( LoadDate(date2, mon2, day2, year2) == -1 )
   {
    fprintf(stderr, "\nInvalid date!\n");
    exit(1);
   }

   numOfdays = DateDiff(date1, date2);

   if(numOfdays < 0)
    numOfdays *= -1L;
   printf("\n\t\tThere are %ld days between the two dates.\n", numOfdays);

   FreeDate(&date1);
   FreeDate(&date2);

   cprintf("\r\n\r\n\r\n\r\n   Press any key to continue... ");
   while (!kbhit())
    ;
   getch();
   clrscr();

}


void example3(void)
{
   tdtype *date1, *date2;
   char output[40];
   int month, day, year, doy;
   long int numOfdays;

   printf("\n\n\n\tEnter your birth date, month, day, and full year... ");
   scanf("%d%d%d", &month, &day, &year);
   
   date1 = CreateDate();
   date2 = TimeDate();	 /* The current time/date info. */
			 
   if( LoadDate(date1, month, day, year) == -1 )
   {
     fprintf(stderr, "\nInvalid date!\n");
     exit(1);
   }
   
   numOfdays = DateDiff(date1, date2);
   
   doy = DayOfYear(date1);

   printf("\n\n\t\tYou are %ld days old ", numOfdays); 
   TDFormat(date1, output, 40, "and were born on a %A,");
   printf("%s\n", output);
   printf("\t\twhich was day %d of that year. ", doy);

   FreeDate(&date1);

   sleep(13);
   clrscr();
   printf("\n\n\n\t\tThe same types of calculations can be done\n");
   printf("\t\tusing hours, minutes, and seconds and your no\n");
   printf("\t\tlonger limited by Ansi's 1900-and-up-only rule\n");
   printf("\t\tfor dates or times.  ");
   sleep(15);
   clrscr();
}



void DisplayFormats(void)
{   
   char output[80];
   tdtype *date;
   
   clrscr();
   printf("\n\n\n\t\tAll of the format specifiers match the\n");
   printf("\t\tBorland Library reference so there is no\n");
   printf("\t\tneed to learn any new syntax.\n");
   printf("\t\tConverting from 24 to 12 hour time is automatic\n");
   printf("\t\tand will display 12:10 AM as 12:10 AM, NOT 00:10 AM. ");
   sleep(14);
   printf("\n\n\t\tHere are the standard formats for the current\n");
   printf("\t\ttime and date settings on your system: ");
   sleep(8);
   clrscr();
   
   date = TimeDate();	 /* Get current settings. */

   printf("\tCurrent settings:\n");
   TDFormat(date, output, 80, "%% ->       the %% character:  %%");
   printf("\t\t%s\n", output);
   
   TDFormat(date, output, 80, "%%a ->  abbreviated weekday:  %a");
   printf("\t\t%s\n", output);
   
   TDFormat(date, output, 80, "%%A ->    full weekday name:  %A");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%b ->    abbreviated month:  %b");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%B ->  full calendar month:  %B");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%c ->     date/time (Unix):  %c");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%d ->    2-digit month day:  %d");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%H ->    hour (24 hr fmt.):  %H");
   printf("\t\t%s\n", output);   

   TDFormat(date, output, 80, "%%I ->    hour (12 hr fmt.):  %I");
   printf("\t\t%s\n", output);
   
   TDFormat(date, output, 80, "%%j ->  3-digit day of year:  %j");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%m ->   2-digit cal. month:  %m");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%M ->       2-digit minute:  %m");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%p ->             AM or PM:  %p");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%S ->       2-digit second:  %S");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%U ->  2-digit week of year (Sun. begins):  %U");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%W ->  2-digit week of year (Mon. begins):  %W");
   printf("\t\t%s\n", output);
   
   TDFormat(date, output, 80, "%%w ->      1-digit weekday:  %w");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%x ->    date (Unix style):  %x");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%X ->    time (Unix style):  %X");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%y ->         2-digit year:  %y");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%Y ->    year with century:  %Y");
   printf("\t\t%s\n", output);

   TDFormat(date, output, 80, "%%Z ->   Time Zone (if set):  %Z");
   printf("\t\t%s\n", output);
   
   printf("\n\t\tPress any key to continue... ");   
   getch();
   clrscr();
   printf("\n\n\n\t\tAny of the formats can be freely mixed\n");
   printf("\t\tto produce any desired output. ");
   sleep(6);
   clrscr();
   printf("\n\n\n\t\ttd.lib is Freeware, may it go forth and multiply. ");
   sleep(6);
   clrscr();
}