/* showrxd.c: Displays fixed information about Reflex data bases */
/* Written for small model of Turbo C by K. Porter */

/* INCLUDE FILES */
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <reflex.h>       /* Separate Reflex structure definitions */

/* DEFINE CONSTANTS */
#define  OUTDEV    "PRN"                          /* output device */
#define  EJECT     12                        /* printer page eject */

/* LOCAL FUNCTION PROTOTYPES */
void     showMast (char name[], MASTREC *mast);
void     showHead (DFHDR *head);
void     showSort (SORTSPEC *srt);
void     showName (unsigned offset);
void     showField (unsigned nf, FLDDESC *fld);

main ()
{
char           fname[MAXPATH],                         /* filename */
               drive[MAXDRIVE], dir[MAXDIR],         /* components */
               name[MAXFILE], ext[MAXEXT];
long           fpos;                              /* file position */
unsigned       d;                                 /* misc variable */
FILE           *db;                               /* database file */



/* OPEN FILES */
  d = 0;
  lst = fopen ( OUTDEV, "w" );                      /* open output */
  cputs ( "\nName of Reflex data base? " );
  gets ( fname );                                  /* get filename */
  fnsplit ( fname, drive, dir, name, ext );      /* split filename */
  if ( !strlen ( ext ))
     strcpy ( ext, ".RXD" );    /* if no extension, make it ".RXD" */
  fnmerge ( fname, drive, dir, name, ext );      /* and reassemble */
  db = fopen ( fname, "r" );
  if ( db != NULL ) {
    setvbuf ( db, NULL, _IONBF, 0 );       /* make file unbuffered */
           /* ---- verify that file is open and a Reflex data base */
    fseek ( db, 88L, SEEK_SET );  /* point to size of control info */
    fread ( &fpos, sizeof (long), 1, db );               /* get it */
    fseek ( db, 0L, SEEK_SET );                /* repoint to start */
                              /* ---- put control info on the heap */
    base = (unsigned) malloc ((unsigned) fpos);   /* allocate node */
    head = (DFHDR*) base;                    /* set header pointer */
    d = fread (((char*)(base)), sizeof (char), ((int)(fpos)), db);
  }
  if ( db == NULL || d == 0 ) {                   /* error handler */
    printf ( "Error accessing file %s\n", fname );
    printf ( "File is %s open, items read = %u\n",
        (db==NULL ? "not" : ""), d);
    exit (1);
  } else
    if ( strcmp ( head->stamp, RXID ) != 0 ) {
      printf ( "\n\nFile %s is not a Reflex data base\n", fname );
      exit (1);                        /* exit with condition code */
    }

/* INITIALIZE POINTERS TO CONTROL INFO */
#include <inptrrxd.i>

/* SHOW INFORMATION ABOUT DATA BASE */
  showMast (fname, mast);                    /* show master record */
  showHead (head);                           /* list header record */
  showSort (sort);                       /* show global sort specs */
  showField (nflds, dtable);             /* show field descriptors */

/* END OF JOB */
  putc ( EJECT, lst );                               /* eject page */
  close ( lst );                                  /* close printer */
  free ( head );                          /* deallocate heap space */
} /* ---------------- End of main() ------------------------------ */

void  showMast (char name[], MASTREC *mast)  /* show master record */
{
  fprintf ( lst, "Control information for Reflex data base %s:\n",
      name );
  fprintf ( lst, "  Total records      %d\n",
      mast->totalRecs );
  fprintf ( lst, "  Filtered records   %d\n",
      mast->filtRecs );
  fprintf ( lst, "  Number of fields   %d\n", nflds );
} /* ------------------------ */

void  showHead (DFHDR *head)                 /* list header record */
{
  fputs ( "\nHeader record contents:\n", lst );
  fprintf ( lst, "  Size of header          %d\n", head->hdrSz );
  fprintf ( lst, "  Reflex identifier       %s\n", head->stamp );
  fprintf ( lst, "  Corruption indicator    %s\n",
      (head->dirty) ? "Corrupt" : "Clean" );
  fprintf ( lst, "  View version level      %d\n", head->verViews );
  fprintf ( lst, "  Modeling version level  %d\n", head->verModels );
  fprintf ( lst, "  Raw data version level  %d\n", head->verData );
  fprintf ( lst, "  Recalc necessary        %s\n",
      (head->fRecalc) ? "Yes" : "No" );
  fputs ( "  Screen type             ", lst );
  switch ( head->screenType ) {
    case 0: fputs ( "IBM CGA", lst ); break;
    case 1: fputs ( "Hercules", lst ); break;
    case 2: fputs ( "IBM 3270 PC APA", lst ); break;
    case 3: fputs ( "IBM EGA", lst ); break;
    case 4: fputs ( "IBM PGC", lst ); break;
    case 5: fputs ( "AT&T 6300 Series", lst ); break;
    case 6: fputs ( "Sigma 400", lst ); break;
    case 7: fputs ( "STB SuperRes 400", lst ); break;
    default: fputs( "(Unknown)", lst );
  }
  putc ( '\n', lst );
  fprintf ( lst, "  File checksum           %X\n", head->checkSum );
  fputs ( "  Reserved field          (38 unused bytes)\n", lst );
  fprintf ( lst, "  Section descriptors     %d\n", head->sectionCt );
} /* ------------------------ */

void  showSort (SORTSPEC *srt)           /* show global sort specs */
{
unsigned  n, p;
FLDSORTSPEC  *spec;
FLDDESC      *fld;

  fputs ( "\nGlobal sort specifications by precedence:\n", lst );
  for ( n = 0; n < 6; n++ ) {
    spec = srt + n;                     /* point to next sort spec */
    if ( spec->fldType == 0x7F && spec->isAscending ) {
      if ( spec == srt )
        fputs ( "  (None)\n", lst );
      break;                          /* quit on terminator (0xFF) */
    } else
        if ( spec->fieldID <= nflds ) {              /* show order */
          fprintf ( lst, "  %s  Field ", (spec->isAscending)
              ? "Ascending: " : "Descending:" );

                    /* Note: We have to follow a chain of references
                       to find the field name. spec->fieldID gives
                       the field descriptor record #, whose first
                       field is an offset into the fieldname pool,
                       from which we can print the name */

          fld = dtable + spec->fieldID;    /* point to field descr */
          p = fld->nameOffset;          /* get name offset in pool */
          showName ( p );                              /* print it */
        }
  }
} /* ------------------------ */

void  showName (unsigned offset)   /* print pool field name to lst */
{
char   *name;

  name = (char *) pool + offset;         /* node address of string */
  fputs ( name, lst );
  putc ( '\n', lst );
} /* ------------------------ */

void  showField (unsigned nf, FLDDESC *fld)
{                                        /* list field descriptors */
FLDDESC   *f;
unsigned  n;

  fprintf ( lst, "\n%u Field Descriptors:", nf );
  for ( n = 0; n < nf; n++ ) {     /* loop thru table for nf items */
    f = fld + n;                       /* point to next descriptor */
    fputs ( "\n  Field name:      ", lst );
    showName ( f->nameOffset );                 /* list field name */
    fputs ( "  Data type:       ", lst );
    switch ( f->dataType ) {                     /* show data type */
      case 0: fputs ( "Untyped\n", lst ); break;
      case 1: fputs ( "Text\n", lst ); break;
      case 2: fputs ( "Repeating text\n", lst ); break;
      case 3: fputs ( "Date\n", lst );
              fputs ( "  Format:          ", lst );
              switch ( f->precision & 0x07 ) {      /* date format */
                case 0:
                case 1: fputs ( "MM/DD/YY\n", lst ); break;
                case 2: fputs ( "MM/YY\n", lst ); break;
                case 3: fputs ( "DD-Mon-YY\n", lst ); break;
                case 4: fputs ( "Mon-YY\n", lst ); break;
                case 5: fputs ( "Month DD, YYYY\n", lst );
              }
              break;
      case 4: fputs ( "Numeric\n", lst );
              fprintf ( lst, "  Precision        %d\n",
                  (( f->precision & 0xF8 ) >> 3 ));
              fputs ( "  Format           ", lst );
              switch ( f->precision & 0x07 ) {   /* numeric format */
                case 0: fputs ( "General\n", lst ); break;
                case 1: fputs ( "Fixed (-XXX.YY)\n", lst ); break;
                case 2: fputs ( "Scientific (-X.YYe+ZZ)\n", lst );
                        break;
                case 3: fputs ( "General\n", lst ); break;
                case 4: fputs ( "Currency ($X,XXX.YY)\n", lst );
                        break;
                case 5: fputs ( "Financial (X,XXX.YY)\n", lst );
              }
              break;
      case 5: fputs ( "Integer\n", lst ); break;
    }
    fprintf ( lst, "  Field offset     %u\n", f->fldOffset );
  }
} /* ------------------------ */