/****************************************************************

     Example using the pull-down menu tools with status
     bar update.

****************************************************************/

include "tdoms.pro"


DATABASE
  pdwstate(ROW,COL,SYMBOL,ROW,COL)

include "tpreds.pro"
include "status.pro"
include "spulldwn.pro"    /* modified pull-down menu package */

Predicates
  msg(ROW,COL,STRING)

CLAUSES

/* After a menu item is selected, one of the corresponding actions
   is chosen.
*/   
   /* The file pull-down menu options */

  pdwaction(1,1):-msg(3,10,"Load file selected").
  pdwaction(1,2):-msg(4,10,"Save file selected").
  pdwaction(1,3):-msg(5,10,"Directory selected").
  pdwaction(1,4):-msg(6,10,"Print selected").
  pdwaction(1,5):-msg(7,10,"Copy selected").
  pdwaction(1,6):-msg(8,10,"Rename selected").
  pdwaction(1,7):-msg(9,10,"Operating system selected").

   /* The Run menu */
  
  pdwaction(2,0):-msg(3,25,"Run selected").
  
   /* The Help pull-down menu options */ 
  
  pdwaction(3,1):-msg(3,40,"Topic selected").
  pdwaction(3,2):-msg(4,40,"Edit selected").
  pdwaction(3,3):-msg(5,40,"Run selected").
  pdwaction(3,4):-msg(6,40,"Options selected").
  pdwaction(3,5):-msg(7,40,"Quick help selected").

   /* The options pull-down menu options */
  
  pdwaction(4,1):-msg(3,44,"Screen selected").
  pdwaction(4,2):-msg(4,44,"Printer selected").
  pdwaction(4,3):-msg(5,44,"Mouse selected").
  pdwaction(4,4):-msg(6,44,"Options macros").
  
   /* The Quit menu */
  
  pdwaction(5,0):-exit.

  msg(R,C,S):-
        makestatus(112,"Press any key"),
	makewindow(1,7,7,"Message Window",R,C,5,30),
	window_str(S),
	readkey(_),
	removewindow,
	removestatus.

GOAL
/*
          1         2         3         4         5         6
0123456789012345678901234567890123456789012345678901234567890123456789
     Files          Run            Help         Setup          Quit
*/

  makewindow(1,7,0,"",0,0,24,80),
  makestatus(112," Select with arrows or use first upper
                   case letter"),
  spulldown(7,
	  [ curtain(5,"Files",["Load","Save","Directory","Print",
	                       "Copy","Rename","Operating System"]),
	    curtain(20,"Run",[]),
            curtain(35,"Help"    ,["Select topic","Edit","Run",
                                  "Options","Quick help"]),
            curtain(48,"Setup"     ,["Screen","Printer", "Mouse",
                                     "Macros"]),
            curtain(63,"Quit"      ,[])
          ],
          [ stat("Select for file options",
                ["Load a new file",
                 "Save Current file to disk",
                 "View current directory",
                 "Print current file",
                 "Make a copy of current file",
                 "Rename file",
                 "Execute DOS commands"]),
            stat("Execute a program",[]),
            stat("Select for help",["Specify a topic", 
                 "Get help about the editor",  
                 "Get help on running a program",
                 "Get help on the systems options",
                 "Get the quick guide"]),
            stat("Select to setup the system", ["Setup the screen",
                 "Setup the printer", "Setup the mouse",
                 "Setup macros"]),
            stat("Select to exit the program", [])   
          ]  
       	             ,CH,SUBCH ),
       	write("\n    CH = ",CH),
       	write("\n SUBCH = ",SUBCH),nl.

