
Program SampleDoor;

   { Sample DOOR program to access SLBBS data record }

Uses DOS, Crt;


type SlData = record

      PROGID: string[6];                { Program ID } 

      carrier: boolean;                 { carrier check enable }
      writeprotect: boolean;            { disk write protection }
      aborttype: byte;                  { 0=no abort, 1=terminate, 2=reboot }

      rsactive: boolean;                { set if rs232 active }
      ansi: boolean;                    { user ANSI mode }
      color: boolean;                   { user COLOR mode }
      directvid: boolean;               { system DirectVid mode }

      curratt: byte;                    { current video attribute }
      commtype: byte;                   { run parameter }
      idletime: word;                   { idle limit (seconds) }

      lastkey: boolean;                 { TRUE = last key from local kbd }

      OldVector: array[$00..$FF] of pointer;   { old user int vectors }

end;


var regs: registers;
    data: ^SlData;
    save: pointer;
    c: char;


Begin

  DirectVideo:=False;       { Do all I/O through BIOS }

  regs.ah:=$C7;
  MsDos(regs);                  { Load pointer to SLBBS data }
  data:=Ptr(regs.ax,regs.bx);

  if data^.progid<>'SLBBS'
    then writeln('Searchlight driver not loaded')

  else begin       { display variables }
    writeln;
    writeln('Carrier Check:    ',data^.carrier);
    writeln('Write Protection: ',data^.writeprotect);
    writeln('Direct Video:     ',data^.directvid);
    writeln('Idle Time:        ',data^.idletime);
    writeln;

    if data^.rsactive then begin
      writeln('Accessing Original INT10 Address...');

      GetIntVec($10,save);                  { read existing address }
      SetIntVec($10,Data^.OldVector[$10]);  { restore original BIOS address }

      writeln('This line of output appears on the Local CRT only.');
      writeln;

      SetIntVec($10,save);                  { put SLBBS address back }
      writeln('SLBBS Vector Restored.');
      writeln;
    end;

    write('Press a key when ready ...');
    while not keypressed do ;
    c:=readkey;
    writeln;

    if data^.lastkey
      then writeln(' Key hit came from local keyboard.')
      else writeln(' Key hit came from remote keyboard.');

  end;

end.

