'  -- DATETIME.BAS --
'
'  This program is donated to the Public
'  Domain by MarshallSoft Computing, Inc.
'  It is provided as an example of the use
'  of the Personal Communications Library.
'
$CPU 8086          'make compatible with XT systems
$LIB ALL OFF       'turn off all PowerBASIC libraries
$ERROR ALL OFF     'turn off all PowerBASIC error checking
$OPTIMIZE SIZE     'optimize for smaller code
$COMPILE UNIT      'compile to a UNIT (.PBU)

DEFWRD A-Z


  %FLAGS = 0
  %AX = 1
  %BX = 2
  %CX = 3
  %DX = 4
  %SI = 5
  %DI = 6
  %BP = 7
  %DS = 8
  %ES = 9
  %False = 0
  %True  = NOT %False

FUNCTION DosOpen(BYVAL Filename AS STRING) PUBLIC AS INTEGER
  DIM Carry AS BYTE
  REG %AX,&H3D00
  Filename = Filename + CHR$(0)
  REG %DS,STRSEG(Filename)
  REG %DX,STRPTR(Filename)
  CALL INTERRUPT &H21
  Carry = 1 AND REG(%FLAGS)
  IF Carry THEN
    DosOpen = 0 - REG(%AX)
  ELSE
    DosOpen = REG(%AX)
  END IF
END FUNCTION

FUNCTION DosClose(BYVAL Handle AS INTEGER) PUBLIC AS INTEGER
  DIM Carry AS BYTE
  REG %AX,&H3E00
  REG %BX,Handle
  CALL INTERRUPT &H21
  Carry = 1 AND REG(%FLAGS)
  IF Carry THEN
    DosClose = 0 - REG(%AX)
  ELSE
    DosClose = REG(%AX)
  END IF
END FUNCTION

FUNCTION GetFileDT(BYVAL Handle  AS INTEGER, _
                         TheDate AS WORD, _
                         TheTime AS WORD) PUBLIC AS INTEGER
 DIM Carry AS BYTE
 REG %AX,&H5700
 REG %BX,Handle
 CALL INTERRUPT &H21
 TheTime = REG(%CX)
 TheDate = REG(%DX)
 Carry = 1 AND REG(%FLAGS)
 IF Carry THEN
   GetFileDT = %False
 ELSE
   GetFileDT = %True
 END IF
END FUNCTION

FUNCTION SetFileDT(BYVAL Handle AS INTEGER, _
                   BYVAL TheDate AS WORD, _
                   BYVAL TheTime AS WORD) PUBLIC AS INTEGER
  DIM Carry AS BYTE
  REG %AX,&H5701
  REG %BX,Handle
  REG %CX,TheTime
  REG %DX,TheDate
  CALL INTERRUPT &H21
  Carry = 1 AND REG(%FLAGS)
  IF Carry THEN
    SetFileDT = %False
  ELSE
    SetFileDT = %True
  END IF
END FUNCTION

' packed date word = [yyyyyyym|mmmddddd] = year(7), month(4), day(5)

SUB PackDate(BYVAL Year AS BYTE, _
             BYVAL Month AS BYTE, _
             BYVAL Day AS BYTE, _
                   TheDate AS WORD) PUBLIC
  TheDate = Year - 80
  SHIFT LEFT TheDate, 4
  TheDate = TheDate OR Month
  SHIFT LEFT TheDate,5
  TheDate = TheDate OR Day
END SUB

SUB UnpackDate(BYVAL TheDate AS WORD, _
                     Year AS BYTE, _
                     Month AS BYTE, _
                     Day AS BYTE) PUBLIC
Day = &H1F AND TheDate
SHIFT RIGHT TheDate, 5
Month = &H0F AND TheDate
SHIFT RIGHT TheDate, 4
Year = 80 + (&H7F AND TheDate)
END SUB

' packed time word = [hhhhhmmm|mmmsssss] = hour(5), minutes(6), seconds (5)

SUB PackTime(BYVAL Hours AS BYTE, _
             BYVAL Minutes AS BYTE, _
             BYVAL Seconds AS BYTE, _
                   TheTime AS WORD) PUBLIC
TheTime = Hours
SHIFT LEFT TheTime,6
TheTime = TheTime OR Minutes
SHIFT LEFT TheTime,5
TheTime = TheTime OR Seconds
END SUB


SUB UnpackTime(BYVAL TheTime AS WORD, _
                     Hours AS BYTE, _
                     Minutes AS BYTE, _
                     Seconds AS BYTE) PUBLIC
Seconds = &H001F AND TheTime
SHIFT RIGHT TheTime,5
Minutes = &H003F AND TheTime
SHIFT RIGHT  TheTime,6
Hours = &H1F AND TheTime
END SUB