;*******************************************************************
:* Comando : iequ
;* Comentarios : esta funcion se usa para insertar simbolos
;* unilineales en una forma mas natural que con el comando insert.
;* Se usa basicamente para los bloques elementales
;*******************************************************************
;
; Change Log
;
; 14/10/94 C.Perigault  Creacion
;
(defun c:iequ ()

   ; para evitar el echo de los comandos
   (setq cmdecho (getvar "CMDECHO"))
   ;(setvar "CMDECHO" 0)
    
   ; SUBCAN varible del sistema que posee el path dondo se encuentran 
   ; los dibujos de canalizacion
   (setq nombre (getstring "\nNombre del equipo: "))
   (setq path   (getenv "SUBEQU")) 
   
   
   ; el nombre del bloque en alambre
   (setq nombreBloqueAlambre (strcat "ALA_" nombre))

     
     ; primero vemos si el dibujo ya ha sido insertado con aterioridad
     ; de no ser asi lo buscamos en el disco  
     (if (tblsearch "BLOCK" nombre)
       (progn
         ; ahora insertamos el bloque en alambre
         (if (tblsearch "BLOCK" nombreBloqueAlambre)
           (progn
             (setvar "TEXTEVAL" 1)
             (command "INSERT" nombreBloqueAlambre pause)
             (setvar "TEXTEVAL" 0)
           ); end prog
           (princ (strcat "\nEl bloque en alambre de: " nombre " no se ecuentra"))
          ); end if
        ); end progn
       ; buscamos el dibujo en el disco
       (if (findfile (strcat path "\\" nombre ".dwg"))
         (progn
	   ; insertamos el dibujo de definicion del equipo
           ; y luego lo borramos, ya que solo nos interesan
           ; los bloques definidos en le dibujo
           (command "INSERT" (strcat path "\\" nombre) '(0 0 0) "" "" "")
           (command "ERASE" "LAST" "")
           
           ; ahora insertamos el bloque en alambre
           (if (tblsearch "BLOCK" nombreBloqueAlambre)
             (progn
               (setvar "TEXTEVAL" 1)
               (command "INSERT" nombreBloqueAlambre pause)
               (setvar "TEXTEVAL" 0)
             ); end progn
             (princ (strcat "\nEl bloque en alambre de: " nombre " no se ecuentra"))
           ); end if
          ); end progn
        
       (princ (strcat "\nEl equipo: " nombre " no se encuentra" ))
       ); end if
      ); end if
   (setvar "CMDECHO" cmdecho)
) ; end defun
