/*
   Module:  main.c
   Date:    3/9/92
   Version: 1.0b
   Author:  Dave Lutz
   Email:   lutz@psych.rochester.edu
   Copyright: 1992 University of Rochester, Psychology Dept.

   Disclaimer:  This software is distributed free of charge.  As such, it
                comes with ABSOLUTELY NO WARRANTY.  The user of the software
                assumes ALL RISKS associated with its use.

                Your rights to modify and/or distribute this software are
                outlined in the file ADI7221.DOC.

   Purpose: This module provides the constant definitions for the return
            codes used by the functions in the ADI conversion utitility.
*/

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef NULL
#define NULL 0
#endif

   /* to avoid conflicts, the following codes should be out of the range of
      valid ADI command codes (1-9).  This is especially critical for BADCMD
      and BADFMT, since they are returned in place of an ADI code in some
      instances.
   */

#define ALLOK   0    /* program ran to completion with no errors */
#define BADARGS 10   /* illegal command line */
#define NOBUFF  11   /* couldn't allocate file buffer */
#define BADOPEN 12   /* couldn't open file */
#define BADIO   13   /* file read or write failed */
#define NOTADI  14   /* input file is not an ADI plot file */
#define BADCMD  14   /* illegal ADI command */
#define BADFMT  15   /* illegal argument format for ADI command */
#define ABORTED 16   /* ADI abort command was encountered in input file */
#define NOEND   17   /* no END_PLOT encountered in input file */
