#---------------------------------------------------------------
#
#	Unix Makefile for Space Flight Simulator
#
#	X11 Implementation
#
#---------------------------------------------------------------

#---------------------------------------------------------------
# Flags for all modules

CFLAGS=		-DDEBUG -O -I../../include

#---------------------------------------------------------------
# user interface and astronomy object files

LIBS=		../../lib/ui_boxes.o ../../lib/ui_dial.o \
		../../lib/ui_init.o ../../lib/ui_list.o ../../lib/ui_text.o \
		../../lib/ui_gets.o ../../lib/ui_pbm.o \
		../../lib/gr_x.o \
                ../../lib/dr_unix.o ../../lib/kb_x.o

AST=		as_orbit.o as_focus.o as_vpt.o \
		as_spj.o

#---------------------------------------------------------------
# Common object files

COMM=		sfs_pr.o sfs_pe.o

#---------------------------------------------------------------
# Modeling module object files

SFSM=		sfsm.o sfsm_om.o

#---------------------------------------------------------------
# Simulation module object files

SFSX=		sfsx.o sfsx_cp.o \
		sfsx_sp.o sfsx_var.o \
		sfs_ft.o sfs_gt.o \
		sfs_di.o sfs_vi.o

#---------------------------------------------------------------
# Build all modules

all:		sfs sfsm sfsx

#---------------------------------------------------------------
# Build the program loader

sfs:		sfs.o
		$(CC) -O sfs.o -o sfs
		mv sfs ../bin

#---------------------------------------------------------------
# Build the modeling module

sfsm:		$(SFSM) $(COMM) $(AST) 
		$(CC) $(SFSM) $(COMM) $(LIBS) $(AST) \
                -lX11 -lm -o sfsm.app
		mv sfsm.app ../bin

#---------------------------------------------------------------
# Build the simulation module

sfsx:		$(SFSX) $(COMM) $(AST) 
		$(CC) $(SFSX) $(COMM) $(LIBS) $(AST) \
                -lX11 -lm -o sfsx.app
		mv sfsx.app ../bin

#--------------------------------------------------------------
# astronomical subroutines dependencies

as_orbit.o:
		$(CC) $(CFLAGS) -c ../as/as_orbit.c

as_focus.o:
		$(CC) $(CFLAGS) -c ../as/as_focus.c

as_vpt.o:
		$(CC) $(CFLAGS) -c ../as/as_vpt.c

as_spj.o:
		$(CC) $(CFLAGS) -c ../as/as_spj.c

#---------------------------------------------------------------
# End of makefile.x
#---------------------------------------------------------------
