/* Constellation names
 */

#include <stdio.h>

#define NCON 89
char *constel[NCON] = {
"And Andromedae",
"Ant Antliae",
"Aps Apodis",
"Aql Aquilae",
"Aqr Aquarii",
"Ari Arietis",
"Ara Arae",
"Aur Aurigae",
"Boo Bootis",
"Cae Caeli",
"Cam Camelopardalis",
"Can Cancri",		/* also abbreviated Cnc */
"Cap Capricorni",
"Car Carinae",
"Cas Cassiopeiae",
"Cen Centauri",
"Cep Cephei",
"Cet Ceti",
"Cha Chamaeleontis",
"Cir Circini",
"CMa Canis Majoris",
"CMi Canis Minoris",
"Cnc Cancri",
"Col Columbae",
"Com Comae Berenices",
"CrA Coronae Austrinae",
"CrB Coronae Borealis",
"Crt Crateris",
"Cru Crucis",
"Crv Corvi",
"CVn Canum Venaticorum",
"Cyg Cygni",
"Del Delphini",
"Dor Doradus",
"Dra Draconis",
"Equ Equulei",
"Eri Eridani",
"For Fornacis",
"Gem Geminorum",
"Gru Gruis",
"Her Herculis",
"Hor Horologii",
"Hya Hydrae",
"Hyi Hydri",
"Ind Indi",
"Lac Lacertae",
"Leo Leonis",
"Lep Leporis",
"Lib Librae",
"LMi Leonis Minoris",
"Lup Lupi",
"Lyn Lyncis",
"Lyr Lyrae",
"Men Mensae",
"Mic Microscopii",
"Mon Monocerotis",
"Mus Muscae",
"Nor Normae",
"Oct Octantis",
"Oph Ophiuchi",
"Ori Orionis",
"Pav Pavonis",
"Peg Pegasi",
"Per Persei",
"Phe Phoenicis",
"Pic Pictoris",
"PsA Piscis Austrini",
"Psc Piscium",
"Pup Puppis",
"Pyx Pyxidis",
"Ret Reticuli",
"Scl Sculptoris",
"Sco Scorpii",
"Sct Scuti",
"Ser Serpentis",
"Sex Sextantis",
"Sge Sagittae",
"Sgr Sagittarii",
"Tau Tauri",
"Tel Telescopii",
"TrA Trianguli Australis",
"Tri Trianguli",
"Tuc Tucanae",
"UMa Ursae Majoris",
"UMi Ursae Minoris",
"Vel Velorum",
"Vir Virginis",
"Vol Volantis",
"Vul Vulpeculae",
};



/* Greek letters
 */

#define NGREEK 24
char *greek[NGREEK] = {
"alpha",
"beta",
"gamma",
"delta",
"epsilon",
"zeta",
"eta",
"theta",
"iota",
"kappa",
"lambda",
"mu",
"nu",
"xi",
"omicron",
"pi",
"rho",
"sigma",
"tau",
"upsilon",
"phi",
"chi",
"psi",
"omega",
};

#if __STDC__
static int islow (char *);
static int isup (char *);
static int isnumber (char *);
static int skipwh(char *);
#else
static int islow(), isup(), isnumber(), skipwh();
#endif

int showcname( in )
char *in;
{
char *g, *p, *q;
char ans[80];
int i;


p = in;
q = ans;


skipwh(p);
if( isnumber(p) )
	{
	while( isnumber(p) )
		*q++ = *p++;
	}
skipwh(p);
*q++ = ' ';

if( islow(p) )
	{
	for( i=0; i<NGREEK; i++ )
		{
		g = greek[i];
		if( (*p == *g) && (*(p+1) == *(g+1)) )
			break;
		}
	if( i < NGREEK )
		{
		while( *g != '\0' )
			*q++ = *g++;
		}
	while( islow(p) )
		++p;
	}
skipwh(p);
/* copy things like "-a" until uppercase letter found */
while( (*p != '\0') && !isup(p) )
	*q++ = *p++;

*q++ = ' ';

if( isup(p) )
	{
/* Check the list of constellation names */
	for( i=0; i<NCON; i++ )
		{
		g = constel[i];
		if( (*p == *g) && ( *(p+1) == *(g+1) )
			&& ( *(p+2) == *(g+2) ) )
			break;
		}
/* Get the name found */
	if( i < NCON )
		{
		g += 4;
		while( *g != '\0' )
			*q++ = *g++;
		p += 3;
		}
	}
skipwh(p);
*q++ = ' ';
while( *p )
	*q++ = *p++;
*q++ = '\0';
/* convert all '_' characters to spaces */
q = ans;
while( *q != '\0' )
	{
	if( *q == '_' )
		*q = ' ';
	++q;
	}
printf( "\n              %s\n", ans );
return(0);
}




static int islow(p)
char *p;
{
if( (*p >= 'a') && (*p <= 'z') )
	return(1);
else
	return(0);
}



static int isup(p)
char *p;
{
if( (*p >= 'A') && (*p <= 'Z') )
	return(1);
else
	return(0);
}




static int isnumber(p)
char *p;
{
if( (*p >= '0') && (*p <= '9') )
	return(1);
else
	return(0);
}



static int skipwh(p)
char *p;
{
while( ((*p == ' ') || (*p == '\t') || (*p == '_'))
	&& (*p != '\0') && (*p != '\n') && (*p != '\r') )
		++p;
return(0);
}

