;
; *** Listing 13-22 ***
;
; Replacement code for BlockDrawImage in Listing 11-34.
; This version uses in-line code to eliminate branching
; entirely during the drawing of each image (eliminates
; the branching between the drawing of each pair of lines.)
;----------------------------------------------------------
; Block-move draws the image of a 3-color square at the
; specified screen location. Assumes images start on
; even-numbered scan lines and are an even number of
; scan lines high. Always draws images byte-aligned in
; display memory.
;
; Input:
;	CX = X coordinate of upper left corner at which to
;		draw image (will be adjusted to nearest
;		less-than or equal-to multiple of 4 in order
;		to byte-align)
;	DX = Y coordinate of upper left corner at which to
;		draw image
;	ES = display memory segment
;
; Output: none
;
; Registers altered: AX, CX, DX, SI, DI, BP
;
BlockDrawImage:
	shr	dx,1	;divide the row # by 2 to compensate
			; for the 2-bank nature of 320x200
			; 4-color mode
	mov	ax,SCREEN_WIDTH
	mul	dx	;start offset of top row of image in
			; display memory
	shr	cx,1	;divide the X coordinate by 4
	shr	cx,1	; because there are 4 pixels per
			; byte
	add	ax,cx	;point to the offset at which the
			; upper left byte of the image will
			; go
	mov	di,ax
	mov	si,offset TheImage
			;point to the start of the one image
			; we always draw
	mov	ax,BANK_OFFSET-SCREEN_WIDTH+IMAGE_WIDTH
			;offset from the end of an odd line
			; of the image in display memory to
			; the start of the next even line of
			; the image
	mov	dx,BANK_OFFSET-IMAGE_WIDTH
			;offset from the end of an even line
			; of the image in display memory to
			; the start of the next odd line of
			; the image
	mov	bp,IMAGE_WIDTH/2
			;# of words to draw per row of the
			; image. Note that IMAGE_WIDTH must
			; be an even number since we XOR
			; the image a word at a time
	rept	IMAGE_HEIGHT/2
	mov	cx,bp	;# of words to draw per row of the
			; image
	rep	movsw	;draw a whole even row with this one
			; repeated instruction
	add	di,dx	;point to the start of the next
			; (odd) row of the image, which is
			; in the second bank of display
			; memory
	mov	cx,bp	;# of words to draw per row of the
			; image
	rep	movsw	;draw a whole odd row with this one
			; repeated instruction
	sub	di,ax
			;point to the start of the next
			; (even) row of the image, which is
			; in the first bank of display
			; memory
	endm
	ret
