;
; *** Listing 9-18 ***
;
; Supports the use of CX to store a loop count and CL
; to store a shift count by using XCHG to swap the
; contents of CL as needed.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	1000
Array1	db	ARRAY_LENGTH dup (3)
Array2	db	ARRAY_LENGTH dup (2)
;
Skip:
	mov	si,offset Array1 ;point to the source array
	mov	di,offset Array2 ;point to the dest array
	mov	ax,ds
	mov	es,ax		;copy to & from same segment
	mov	cx,ARRAY_LENGTH	;the loop count
	mov	dl,2		;the shift count
	call	ZTimerOn
ProcessingLoop:
	lodsb			;get the next byte
	xchg	cl,dl		;get the shift count into CL
				; and save the low byte of
				; the loop count in DL
	shl	al,cl		;shift the byte
	xchg	cl,dl		;put the shift count back
				; into DL and restore the
				; low byte of the loop count
				; to CL
	stosb			;save the modified byte
	loop	ProcessingLoop
	call	ZTimerOff
