;
; *** Listing 9-17 ***
;
; Supports the use of CX to store a loop count and CL
; to store a shift count by pushing and popping the loop
; count around the use of the shift count.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	1000
Array1	db	ARRAY_LENGTH dup (3)
Array2	db	ARRAY_LENGTH dup (2)
;
Skip:
	mov	si,offset Array1 ;point to the source array
	mov	di,offset Array2 ;point to the dest array
	mov	ax,ds
	mov	es,ax		;copy to & from same segment
	mov	cx,ARRAY_LENGTH	;the loop count
	mov	dl,2		;the shift count
	call	ZTimerOn
ProcessingLoop:
	lodsb			;get the next byte
	push	cx		;save the loop count
	mov	cl,dl		;get the shift count into CL
	shl	al,cl		;shift the byte
	pop	cx		;get back the loop count
	stosb			;save the modified byte
	loop	ProcessingLoop
	call	ZTimerOff
