	page 60, 132
	title	BIN2HEX - A Binary To Hex Conversion Procedure
	name	BIN2HEX
comment 
	BIN2HEX							V1.00
==========================================================================
NAME
	BIN2HEX - A Binary To Hex Conversion Procedure

SYNOPSIS
	DS:DI => Destination.  AX word
	mov	ax, seg TARGET		; Only needed if TARGET is not
	mov	ds, ax			;  currently addressable by DS
	mov	di, offset TARGET
	mov	dx, SOURCE
	call	Bin2Hex

DESCRIPTION
	This procedure converts a binary word into a hexidecimal ASCIIZ
	string.

CAUTION
	None

RETURNS
	Nothing

PROGRAMMING NOTES
	Assembled with Microsoft MASM V6.11d.  Written to link with any
	memory model.

	Use MEMMOD to specify the memory model.
	/dMEMMOD=TINY|SMALL|COMPACT|MEDIUM|LARGE|HUGE

	This procedures uses the inline hexidecimal conversion algorithm

	For digits 0h-9h, 6ah is subtracted to get values 96h-9fh.  The DAS
	instruction converts them to 30h-39h sequence which are the digits
	in ascii.

	For digits 0ah-0fh, 69h is subtracted to get values 0a1-0a6h.
	The DAS instruction convert them to 41h-46h sequence which are
	the alpha digits in ascii.  The value subtracted must be less by
	one because the difference between ascii '1' and ascii 'a' is seven.

	Note:  The DAS instruction will subtract 6 from each nibble in
	AL register if that nibble is greater than 9 in value.

	The above algorithm outputs the alpha digits as uppercase.  The high
	order nibble is or'ed with 2h so that the nibble is converted from
	4h to 6h which will convert to lower case.  If the digit is numeric,
	this nibble is 3h so or'ing with 2h does not change the value.

REGISTER USAGE
	All Memory Models:
	AX, BX, CX, DX	and DI.  No registers are preserved.

MEMORY REQUIREMENTS	(using 286 instructions set)
	(in bytes)	Tiny   Small   Compact	Medium	 Large	Huge
	Code:		 32	 32	   32	   32	   32	 32
	_Data:		  0	  0	    0	    0	    0	  0
	Const:		  0	  0	    0	    0	    0	  0
	_BBS:		  0	  0	    0	    0	    0	  0
	Stack:		  2	  2	    2	    4	    4	  4

EXTERNAL LIBRARIES
	None
	
EXTERNAL PROCEDURES
	None

INTERUPTS CALLED
	None

GLOBAL NAMES
	Bin2Hex

AUTHOR
	Raymond Moon - 6 Oct 95

	Copyright (c) 1995 - Raymond Moon
	ALL RIGHTS RESERVED

HISTORY
	Version	- Date		- Remarks
	1.00	-  6 Oct 95	- Orginal
==========================================================================
	 Comment End

;----------------------------
;	Make the small memory model the default.

ifndef	memmod
memmod	equ	<small>
endif

;----------------------------
;	Specify processor, memory model, language and ES register assume. 

	include procesor.inc			; Specify target processor
%	.model memmod, fortran
	assume es:DGROUP

;=========================================================================
;	CODE
;=========================================================================
;	Start Code Segment and define BIN2HEX procedure

	.CODE

Bin2Hex	proc

;----------------------------
;	DS:DI => Destination.  DX is word to be converted.  Use CX as loop
;	counter; 4 for 4 hexidecimal digits.

	mov	cx, 4			; Outer loop initialized to 4

;----------------------------
;	Move the next 4 bits into AX register to process.  Do this using an
;	inner loop.

BH1:	xor	ax, ax			; Ensure that AX is clear
	mov	bx, cx			; Save outer loop counter
	mov	cx, 4			; Inner loop initialized to 4
BH2:	rcl	dx, 1			; Cycle LSB from DX to Carry Flag
	rcl	ax, 1			; Cycle Carry Flag into LSB in AX
	loop	BH2			; Do four times
	mov	cx, bx			; Restore outer loop

;----------------------------
;	Convert into hexidecimal digit.  Convert to lowercase alpha digits
;	by converting high order nibble from 4h to 6h by or'ing with 2h.

	cmp	al, 0ah 		; Set CF if al < 10 - numeric digit
	sbb	al, 69h 		; Subtract 69h if hex, 6ah otherwise
	das				; Convert into hexidecimal
	or	al, 20h 		; Convert into lowercase

;----------------------------
;	Store result and loop until incomplete.

	stosb				; Store result
	loop	BH1			; Loop until done

;----------------------------
;	Conversion complete.  Null terminate.

	xor	ax, ax			; AX = Null
	stosb				; Store it to null terminate

;---------------------------
;	Return

	ret				; Retrun

Bin2Hex	endp
	end
