;// MultiMedia eXtention macroes version 0.4 BETA.
;//   These macroes are identical to those provided by intel for
;// the MASM assembler except that they are to be used in borland's
;// ideal mode.

;//   You can use this file under two restrictions:
;//   - You cannot remove my name or email address from this file.
;//   - If you see bugs, errors or improvements report them to my email address.

;//In a word, don't steel my work and help make this product a pleasure to work with.

;//     Normand Leclerc(lecn1306@ele.etsmtl.ca)

;//Intel and MMX are registered to Intel corporation.
;//Turbo Assembler is registered to Borland International.
;//MASM is registered to Microsoft corporation.



;// To be compiled with at least 2 passes.
;// For 32 bits programming, you must define '@32Bit' to 1.
;// (@32Bit is defined if you use the simplified segmentation syntax)

ifndef __MMX__
  display       "including mmx.ash"
  __MMX__=1
endif

ifndef @32Bit
  @32Bit        equ 0
endif

;// Data types (don't know if this will be usefull... Hey you never know!)
_packed_bytes           equ     00b     ;// 1122334455667788
_packed_words           equ     01b     ;// 1111222233334444
_packed_doubles         equ     10b     ;// 1111111122222222
_quadwords              equ     11b     ;// 1111111111111111


;// MMX opcodes
_opc_emms               equ     77h
_opc_movd_ld            equ     6eh
_opc_movd_st            equ     7eh
_opc_movq_ld            equ     6fh
_opc_movq_st            equ     7fh
_opc_packssdw           equ     6bh
_opc_packsswb           equ     63h
_opc_packuswb           equ     67h
_opc_paddb              equ     0fch
_opc_paddd              equ     0feh
_opc_paddsb             equ     0ech
_opc_paddsw             equ     0edh
_opc_paddusb            equ     0dch
_opc_paddusw            equ     0ddh
_opc_paddw              equ     0fdh
_opc_pand               equ     0dbh
_opc_pandn              equ     0dfh
_opc_pcmpeqb            equ     74h
_opc_pcmpeqd            equ     76h
_opc_pcmpeqw            equ     75h
_opc_pcmpgtb            equ     64h
_opc_pcmpgtd            equ     66h
_opc_pcmpgtw            equ     65h
_opc_pmaddwd            equ     0f5h
_opc_pmulhw             equ     0e5h
_opc_pmullw             equ     0d5h
_opc_por                equ     0ebh
_opc_pshimd             equ     72h
_opc_pshimq             equ     73h
_opc_pshimw             equ     71h
_opc_pslld              equ     0f2h
_opc_psllq              equ     0f3h
_opc_psllw              equ     0f1h
_opc_psrad              equ     0e2h
_opc_psraw              equ     0e1h
_opc_psrld              equ     0d2h
_opc_psrlq              equ     0d3h
_opc_psrlw              equ     0d1h
_opc_psubb              equ     0f8h
_opc_psubd              equ     0fah
_opc_psubsb             equ     0e8h
_opc_psubsw             equ     0e9h
_opc_psubusb            equ     0d8h
_opc_psubusw            equ     0d9h
_opc_psubw              equ     0f9h
_opc_punpckhbw          equ     68h
_opc_punpckhwd          equ     69h
_opc_punpckhdq          equ     6ah
_opc_punpcklbw          equ     60h
_opc_punpcklwd          equ     61h
_opc_punpckldq          equ     62h
_opc_pxor               equ     0efh
_opc_rdpmc              equ     33h

;// MMX registers (condemned text strings mm[0-7])
macro   defineMMxRegs
  if @32Bit eq 0
    mm0                 equ     <ax>
    mm1                 equ     <cx>
    mm2                 equ     <dx>
    mm3                 equ     <bx>
    mm4                 equ     <sp>
    mm5                 equ     <bp>
    mm6                 equ     <si>
    mm7                 equ     <di>
;// Intel wishes a standard word as a size identifier...  Let's define
;// it here and use it if we want to... :)
  typedef mmword  word
  else
    mm0                 equ     <eax>
    mm1                 equ     <ecx>
    mm2                 equ     <edx>
    mm3                 equ     <ebx>
    mm4                 equ     <esp>
    mm5                 equ     <ebp>
    mm6                 equ     <esi>
    mm7                 equ     <edi>
  typedef mmword  dword
  endif
endm

;//   I chose to undefine the mm[0-7] registers to prevent weird code
;// strings like 'mov eax,mm0' or even 'mov ax,mm0'.
macro   undefineMMxRegs
  mm0                   equ     !mm0
  mm1                   equ     !mm1
  mm2                   equ     !mm2
  mm3                   equ     !mm3
  mm4                   equ     !mm4
  mm5                   equ     !mm5
  mm6                   equ     !mm6
  mm7                   equ     !mm7
endm

;// Symbolic types (preprocessor defines)
_prog_pointer           equ     00000001b       ;// program pointer
_data_pointer           equ     00000010b       ;// data pointer
_constant               equ     00000100b       ;// is a constant
_direct_address         equ     00001000b       ;// uses direct access
_reg_used               equ     00010000b       ;// register is used
_symbol_defined         equ     00100000b       ;// symbol is defined
_external               equ     10000000b       ;// externally defined


;// This union will greatly simplify our data initialisation.
;// Everything should be to it's place with this.
union MMxMem
  q                     dq      ?       ;// quadword
  struc                                 ;// doublewords
    d0                  dd      ?
    d1                  dd      ?
  ends
  struc                                 ;// single words
    w0                  dw      ?
    w1                  dw      ?
    w2                  dw      ?
    w3                  dw      ?
  ends
  struc                                 ;// bytes
    b0                  db      ?
    b1                  db      ?
    b2                  db      ?
    b3                  db      ?
    b4                  db      ?
    b5                  db      ?
    b6                  db      ?
    b7                  db      ?
  ends
ends


; /////////////////
;// Instructions //
;/////////////////

;// EMMS, empty MMX state
macro   emms
	db 0fh,_opc_emms
endm

;// These two (movd and movq) gave me a splitting headache!
;// They work great tough. :P

;// MOVD, move doubleword
macro   movd dest:req,src:rest
	local pre,post,string,segovr,extnd,increment,temp

  defineMMxRegs
  string instr <src>,<mm>

  if (string eq 1) and (\
   (symtype src) and _reg_used and \
   not _symbol_defined)                         ;// MMX reg is source
	newreg equ dest
	if (symtype dest) and _reg_used         ;// register operand
	 if @32Bit eq 0
	   newreg substr <dest>,2
	 endif
	endif
pre:    cmpxchg newreg,src
post:   segovr instr <dest>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <dest>,segovr+1
	if (symtype dest) and _reg_used and _data_pointer ;// register used as pointer
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_movd_st
	org post
  else                                          ;// MMX reg not source
    if (symtype src) and _reg_used              ;// register operand
	newreg equ src
	if (symtype src) and not _symbol_defined ;// genuine register
	  if @32Bit eq 0
	    newreg substr <src>,2
	  endif
	endif
pre:    cmpxchg newreg,dest
    else                                        ;// memory operand
pre:    cmpxchg dest,src
    endif
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used and _data_pointer ;// register used as pointer
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_movd_ld
	org post
 endif
 undefineMMxRegs

endm

;// MOVQ, move quadword
macro   movq dest:req,src:rest
	local pre,post,string,segovr,extnd,increment,temp

  defineMMxRegs
  string instr <src>,<mm>

  if (string eq 1) and (\
   (symtype src) and _reg_used and \
   not _symbol_defined)                         ;// MMX reg is source
pre:    cmpxchg dest,src
post:   segovr instr <dest>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <dest>,segovr+1
	if (symtype dest) and _reg_used         ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_movq_st
	org post
  else                                          ;// MMX reg not source
    if (symtype dest) and _reg_used             ;// register operand
pre:    cmpxchg src,dest
    else                                        ;// memory operand
pre:    cmpxchg dest,src
    endif
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_movq_ld
	org post
 endif
 undefineMMxRegs

endm

;// PACKSSDW, pack with signed saturation (words)
macro   packssdw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_packssdw
	org post
 undefineMMxRegs

endm

;// PACKSSWB, pack with signed saturation (bytes)
macro   packsswb dest:req,src:rest
	local source,pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_packsswb
	org post
 undefineMMxRegs

endm

;// PACKUSWB, pack with unsigned saturation (bytes)
macro   packuswb dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_packuswb
	org post
 undefineMMxRegs

endm

;// PADDB, packed add (bytes)
macro   paddb dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_paddb
	org post
 undefineMMxRegs

endm

;// PADDD, packed add (dwords)
macro   paddd dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_paddb
	org post
 undefineMMxRegs

endm

;// PADDSB, packed add with saturation (bytes)
macro   paddsb dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_paddsb
	org post
 undefineMMxRegs

endm

;// PADDSW, packed add with saturation (words)
macro   paddsw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_paddsw
	org post
 undefineMMxRegs

endm

;// PADDUSB, packed add unsigned with saturation (bytes)
macro   paddusb dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_paddusb
	org post
 undefineMMxRegs

endm

;// PADDUSW, packed add unsigned with saturation (words)
macro   paddusw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_paddusw
	org post
 undefineMMxRegs

endm

;// PADDW, packed add (words)
macro   paddw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_paddw
	org post
 undefineMMxRegs

endm

;// PAND, bitwise logical and
macro   pand dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_pand
	org post
 undefineMMxRegs

endm

;// PANDN, bitwise logical and not
macro   pandn dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_pandn
	org post
 undefineMMxRegs

endm

;// PCMPEQB, packed compare for equal (bytes)
macro   pcmpeqb dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_pcmpeqb
	org post
 undefineMMxRegs

endm

;// PCMPEQD, packed compare for equal (dwords)
macro   pcmpeqd dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_pcmpeqd
	org post
 undefineMMxRegs

endm

;// PCMPEQW, packed compare for equal (words)
macro   pcmpeqw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_pcmpeqw
	org post
 undefineMMxRegs

endm

;// PCMPGTB, packed compare for greater than (bytes)
macro   pcmpeqb dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_pcmpgtb
	org post
 undefineMMxRegs

endm

;// PCMGTQD, packed compare for greater than (dwords)
macro   pcmpgtd dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_pcmpgtd
	org post
 undefineMMxRegs

endm

;// PCMGTQW, packed compare for greater than (words)
macro   pcmpgtw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_pcmpgtw
	org post
 undefineMMxRegs

endm

;// PMADDWD, packed multiply and add (dwords)
macro   pmaddwd dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_pmaddwd
	org post
 undefineMMxRegs

endm

;// PMULHW, packed multiply high (words)
macro   pmulhw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_pmulhw
	org post
 undefineMMxRegs

endm

;// PMULLW, packed multiply low (words)
macro   pmullw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_pmullw
	org post
 undefineMMxRegs

endm

;// POR, bitwise logical or
macro   por dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_por
	org post
 undefineMMxRegs

endm

;// PSLLD, packed shift left logical (dwords)
macro   pslld dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:
	if ((symtype src) xor (\
	 _constant or _symbol_defined)) eq 0    ;// constant
	  btr dest,src
post:     org pre+1
	  db  _opc_pshimd
	else
	  cmpxchg src,dest
post:     segovr instr <src>,<:>
	  increment=1
	  if (segovr gt 0)
	    increment=increment+1
	  endif
	  temp substr <src>,segovr+1
	  if (symtype src) and _reg_used        ;// register used
	    extnd instr temp,<e>
	    if (@32Bit eq 0) and (extnd gt 0)
	      increment=increment+1
	    endif
	  endif
	  org pre+increment
	  db  _opc_pslld
	endif
	org post
 undefineMMxRegs

endm

;// PSLLQ, packed shift left logical (quadwords)
macro   psllq dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:
	if ((symtype src) xor (\
	 _constant or _symbol_defined)) eq 0    ;// constant
	  btr dest,src
post:     org pre+1
	  db  _opc_pshimq
	else
	  cmpxchg src,dest
post:     segovr instr <src>,<:>
	  increment=1
	  if (segovr gt 0)
	    increment=increment+1
	  endif
	  temp substr <src>,segovr+1
	  if (symtype src) and _reg_used        ;// register used
	    extnd instr temp,<e>
	    if (@32Bit eq 0) and (extnd gt 0)
	      increment=increment+1
	    endif
	  endif
	  org pre+increment
	  db  _opc_psllq
	endif
	org post
 undefineMMxRegs

endm

;// PSLLW, packed shift left logical (words)
macro   psllw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:
	if ((symtype src) xor (\
	 _constant or _symbol_defined)) eq 0    ;// constant
	  btr dest,src
post:     org pre+1
	  db  _opc_pshimw
	else
	  cmpxchg src,dest
post:     segovr instr <src>,<:>
	  increment=1
	  if (segovr gt 0)
	    increment=increment+1
	  endif
	  temp substr <src>,segovr+1
	  if (symtype src) and _reg_used        ;// register used
	    extnd instr temp,<e>
	    if (@32Bit eq 0) and (extnd gt 0)
	      increment=increment+1
	    endif
	  endif
	  org pre+increment
	  db  _opc_psllw
	endif
	org post
 undefineMMxRegs

endm

;// PSRAD, packed shift right arithmetic (dwords)
macro   psrad dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:
	if ((symtype src) xor (\
	 _constant or _symbol_defined)) eq 0    ;// constant
	  bt dest,src
post:     org pre+1
	  db  _opc_pshimd
	else
	  cmpxchg src,dest
post:     segovr instr <src>,<:>
	  increment=1
	  if (segovr gt 0)
	    increment=increment+1
	  endif
	  temp substr <src>,segovr+1
	  if (symtype src) and _reg_used        ;// register used
	    extnd instr temp,<e>
	    if (@32Bit eq 0) and (extnd gt 0)
	      increment=increment+1
	    endif
	  endif
	  org pre+increment
	    db  _opc_psrad
	endif
	org post
 undefineMMxRegs

endm

;// PSRAW, packed shift right arithmetic (words)
macro   psraw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:
	if ((symtype src) xor (\
	 _constant or _symbol_defined)) eq 0    ;// constant
	  bt dest,src
post:     org pre+1
	  db  _opc_pshimw
	else
	  cmpxchg src,dest
post:     segovr instr <src>,<:>
	  increment=1
	  if (segovr gt 0)
	    increment=increment+1
	  endif
	  temp substr <src>,segovr+1
	  if (symtype src) and _reg_used        ;// register used
	    extnd instr temp,<e>
	    if (@32Bit eq 0) and (extnd gt 0)
	      increment=increment+1
	    endif
	  endif
	  org pre+increment
	  db  _opc_psraw
	endif
	org post
 undefineMMxRegs

endm

;// PSRLD, packed shift right logical (dwords)
macro   psrld dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:
	if ((symtype src) xor (\
	 _constant or _symbol_defined)) eq 0    ;// constant
	  cmpxchg dest,mm2
	  db src
post:     org pre+1
	  db  _opc_pshimd
	else
	  cmpxchg src,dest
post:     segovr instr <src>,<:>
	  increment=1
	  if (segovr gt 0)
	    increment=increment+1
	  endif
	  temp substr <src>,segovr+1
	  if (symtype src) and _reg_used        ;// register used
	    extnd instr temp,<e>
	    if (@32Bit eq 0) and (extnd gt 0)
	      increment=increment+1
	    endif
	  endif
	  org pre+increment
	  db  _opc_psrld
	endif
	org post
 undefineMMxRegs

endm

;// PSRLQ, packed shift right logical (quadwords)
macro   psrlq dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:
	if ((symtype src) xor (\
	 _constant or _symbol_defined)) eq 0    ;// constant
	  cmpxchg dest,mm2
	  db src
post:     org pre+1
	  db  _opc_pshimq
	else
	  cmpxchg src,dest
post:     segovr instr <src>,<:>
	  increment=1
	  if (segovr gt 0)
	    increment=increment+1
	  endif
	  temp substr <src>,segovr+1
	  if (symtype src) and _reg_used        ;// register used
	    extnd instr temp,<e>
	    if (@32Bit eq 0) and (extnd gt 0)
	      increment=increment+1
	    endif
	  endif
	  org pre+increment
	  db  _opc_psrlq
	endif
	org post
 undefineMMxRegs

endm

;// PSRLW, packed shift right logical (words)
macro   psrlw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:
	if ((symtype src) xor (\
	 _constant or _symbol_defined)) eq 0    ;// constant
	  cmpxchg dest,mm2
	  db src
post:     org pre+1
	  db  _opc_pshimw
	else
	  cmpxchg src,dest
post:     segovr instr <src>,<:>
	  increment=1
	  if (segovr gt 0)
	    increment=increment+1
	  endif
	  temp substr <src>,segovr+1
	  if (symtype src) and _reg_used        ;// register used
	    extnd instr temp,<e>
	    if (@32Bit eq 0) and (extnd gt 0)
	      increment=increment+1
	    endif
	  endif
	  org pre+increment
	  db  _opc_psrlw
	endif
	org post
 undefineMMxRegs

endm

;// PSUBB, packet substract (bytes)
macro   psubb dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_psubb
	org post
 undefineMMxRegs

endm

;// PSUBD, packet substract (dwords)
macro   psubd dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_psubd
	org post
 undefineMMxRegs

endm

;// PSUBSB, packet substract with saturation (bytes)
macro   psubsb dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_psubsb
	org post
 undefineMMxRegs

endm

;// PSUBSW, packet substract with saturation (words)
macro   psubsw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_psubsw
	org post
 undefineMMxRegs

endm

;// PSUBUSB, packet substract unsigned with saturation (bytes)
macro   psubusb dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_psubusb
	org post
 undefineMMxRegs

endm

;// PSUBUSW, packet substract unsigned with saturation (words)
macro   psubusw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_psubusw
	org post
 undefineMMxRegs

endm

;// PSUBW, packet substract (words)
macro   psubw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_psubw
	org post
 undefineMMxRegs

endm

;// PUNPCKHBW, Unpack high packed data (words)
macro   punpckhbw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_punpckhbw
	org post
 undefineMMxRegs

endm

;// PUNPCKHDQ, Unpack high packed data (quadwords)
macro   punpckhdq dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_punpckhdq
	org post
 undefineMMxRegs

endm

;// PUNPCKHWD, Unpack high packed data (dwords)
macro   punpckhwd dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_punpckhwd
	org post
 undefineMMxRegs

endm

;// PUNPCKLBW, Unpack low packed data (words)
macro   punpcklbw dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_punpcklbw
	org post
 undefineMMxRegs

endm

;// PUNPCKLDQ, Unpack low packed data (quadwords)
macro   punpckldq dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_punpckldq
	org post
 undefineMMxRegs

endm

;// PUNPCKLWD, Unpack low packed data (dwords)
macro   punpcklwd dest:req,src:rest
	local pre,post,segovr,extnd

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_punpcklwd
	org post
 undefineMMxRegs

endm

;// PXOR, bitwise logical exclusive or
macro   pxor dest:req,src:rest
	local pre,post,segovr,extnd,temp

  defineMMxRegs
pre:    cmpxchg src,dest
post:   segovr instr <src>,<:>
	increment=1
	if (segovr gt 0)
	  increment=increment+1
	endif
	temp substr <src>,segovr+1
	if (symtype src) and _reg_used          ;// register used
	  extnd instr temp,<e>
	  if (@32Bit eq 0) and (extnd gt 0)
	    increment=increment+1
	  endif
	endif
	org pre+increment
	db  _opc_pxor
	org post
 undefineMMxRegs

endm

;// RDPMC, read performance monitoring counter
macro   rdpmc
	db 0fh,_opc_rdpmc
endm

