; Listing 2 from "A CASE of the Jumps" by Tom Swan.  Copyright 1988
; by Tom Swan.  No commercial use of this code without express
; permission of the author.

;-----  This program demonstrates how to write jump (case) tables
;       in 8086-family assembly language.  For MASM 5.0.

        TITLE   CASE.ASM
        PAGE    60,132
        DOSSEG
        .MODEL  small
        .STACK  256

        .DATA

;-----  Jump (case) table of addresses

table           dw      case0, case1, case2, case3

;-----  Various strings

prompt          db      'Enter 0, 1, 2, or 3: ', '$'
msg0            db      13, 10, 'Case statement #0', '$'
msg1            db      13, 10, 'Case statement #1', '$'
msg2            db      13, 10, 'Case statement #2', '$'
msg3            db      13, 10, 'Case statement #3', '$'
errmsg          db      13, 10, 'Data entry error', '$'

        .CODE
start:
        mov     ax,@data                ; initialize DS
        mov     ds,ax

        mov     dx,offset prompt        ; display prompt
        mov     ah,09h
        int     21h

        mov     ah,01                   ; get character
        int     21h

;-----  Test range of char in al.  Prepare bx equal to the case
;       statement number times 2, indexing the 2-byte addresses in
;       the jump table.

        mov     dx,offset errmsg        ; prepare for possible error
        cmp     al,'0'
        jb      endcase                 ; error if al < '0'
        cmp     al,'3'
        ja      endcase                 ; error if al > '3'

        mov     bl,al                   ; move digit char to bl
        and     bx,03h                  ; convert to value 0,1,2,3
        shl     bx,1                    ; multiply bx by 2
        jmp     table[bx]               ; jump to case 0,1,2 or 3

;-----  Each case is a separate routine, ending with a jump to the
;       end-of-case label.

case0:
        mov     dx,offset msg0
        jmp     endcase
case1:
        mov     dx,offset msg1
        jmp     endcase
case2:
        mov     dx,offset msg2
        jmp     endcase
case3:
        mov     dx,offset msg3

;----- Assume dx addresses ASCII$ message to display

endcase:
        mov     ah,09h                  ; display message at dx
        int     21h
        mov     ax,04C00h               ; end with exit code = 0
        int     21h

        END     start                   ; end of text, entry point
