;RON FREIMUTH
PAGE     255,132
         TITLE     IRAND

; INTEGER*2 FUNCTION IRAN[NEAR](MIN[VALUE],MAX[VALUE])
; Returns INTEGER*2 pseudo_random integer in range MIN to MAX
;        MIN <= MAX preferred for max speed
;        Rndint = (Seed*IA+IC) MOD IM
;        Idiff = Max-Min
;        Irand = (Idiff*Rndint)/(IM-1)+Min
; Measured 47 s (336 cycles, 7.15MHz V-30) [60 s first call]
; 11/24/91       Ronald A. Freimuth
; 12/3/91        modified to get clock ticks (David Fox)
; 12/4/91        fixed for ticks in ax every time seed was 0
;


_data    segment word public 'data'
JRAN     dw      0ffffh          ;seed/flag [flag not in normal range]
_data    ends

;------ Magic numbers for linear congruential generator --------
IC       equ     6173            ;constant
IA       equ     1255            ;multiplier
IM       equ     29282           ;modulus, # of different random's returned

dgroup   group   _data

  assume  cs: irand_text, ds: dgroup, ss: dgroup, es: dgroup
;----------------------------------------------------------------------------


irand_text    segment  byte public 'code'

public   IRAND
irand    proc    near    ;Near call, pass by value MIN,MAX signed words
         push    bp
         mov     bp,sp

         mov     ax,JRAN
         cmp     ax,0ffffh       ; check if first call
         jz      get_ticks       ; otherwise, don't get clock ticks

;------ Get new random integer in range 0 to 29281 -----
do_rnd:  mov     cx,IA           ;1255            4
         mul     cx              ;               25
         add     ax,IC           ;6173            4
         adc     dx,0            ;                2
         mov     cx,IM           ;29282           4
         div     cx              ;               22
         mov     JRAN,dx         ;ax mod cx      10
         mov     bx,dx           ;0 to 29281      2   82 cycles

;------ Take absolute value of MAX - MIN -------
         mov     ax,[bp+6]       ;MIN  signed word (probably bp+4 for C)
         mov     bp,[bp+4]       ;MAX              (so this would be bp+6)
         cmp     ax,bp           ;must be larger
         jg      order_ok
         xchg    ax,bp           ;normally executed
order_ok:
         sub     ax,bp           ;ABS(MAX-MIN)

;------ Transform result to range  MIN to MAX ----------
         mul     bx              ;(max-min)*rndint (unsigned)
         dec     cx              ;cx = IM-1
         div     cx              ;dx = remainder, ax = result
         shr     cx,1            ;take half
         cmp     cx,dx           ;check if remainder is < (IM-1)/2
         adc     ax,0            ;round result -equal to below commented code
                                 ;       jae  no_round; jae = jnc
                                 ;       inc  ax;       round up
                                 ; no_round:
         add     ax,bp           ;+ MIN

         pop     bp              ;Must not mov sp,bp
         ret     4               ;two variables (just RET for C)

get_ticks:
         mov     bx,ds           ; save ds
         mov     ax,40h          ; get addressability to 40:6c
         mov     ds,ax
         mov     ax,ds:[6ch]     ; clock ticks 0 - ffff
         mov     ds,bx           ; restore ds
         mov     JRAN,ax
         jmp     do_rnd

irand    endp
irand_text    ends
;

end
