;--------------------------
; leds.asm - by Gertjan Klein
; V1.1 - corrected to assemble with both TASM 2.0 and MASM 5.1

        .MODEL  SMALL
        .CODE
        ORG     100h
        ASSUME  cs:_TEXT,ds:_TEXT,es:_TEXT,ss:_TEXT

main            proc    near

        mov     ax,40h                  ;BIOS data segment
        mov     es,ax                   ; in ES
        mov     dx,offset msg           ;Tell user what's happening
        mov     ah,9                    ;DOS display string function
        int     21h                     ;(DOS)
        mov     al,es:[17h]             ;Get current leds status
        and     al,70h                  ;Mask out leds
        mov     [oldval],al             ; and save them
m1:
        mov     al,1                    ;Set Scroll Lock led
        call    setleds                 ;Set the leds
        call    delay                   ;Wait a while
        mov     al,2                    ;Set Num Lock led
        call    setleds                 ;Set the leds
        call    delay                   ;Wait a while
        mov     al,4                    ;Set Caps Lock led
        call    setleds                 ;Set the leds
        call    delay                   ;Wait a while

        mov     ah,1                    ;Check if key pressed
        int     16h                     ;(BIOS)
        jz      m1                      ; no: keep on flashing
        mov     ah,0                    ; yes: get it
        int     16h                     ;(BIOS)

        and     byte ptr es:[17h],NOT 70h ;Clear current leds (just in case)
        mov     al,[oldval]             ;Get old value
        or      byte ptr es:[17h], al   ;'Or' them in
        mov     cl,4                    ;Shift them to right position
        shr     al,cl                   ; for setleds
        call    setleds                 ;Set leds to old value

        mov     ax,4c00h                ;Back to DOS with errorlevel 0
        int     21h

main            endp

;********************************************************************

setleds         proc    near

        mov     ah,al                   ;Save leds value in ah
sl1:
        in      al,64h                  ;Get keyboard status
        test    al,2                    ;Command in output buffer?
        jnz     sl1                     ; yes: wait until it's gone
        and     byte ptr es:[97h],NOT 10h ;Clear "ACK received" bit
        mov     al,0edh                 ;Keyboard set leds command
        out     60h,al
sl2:
        test    byte ptr es:[97h],10h   ;ACK received yet?
        jz      sl2                     ; no: wait until it is
        mov     al,ah                   ;Get leds byte
        out     60h,al                  ;Output it to keyboard
        ret                             ;Return to caller

setleds         endp

;********************************************************************

delay           proc    near

        mov     cx,7                    ;Long wait value
w1:
        push    cx                      ;Save it
        mov     cx,-1                   ;Short wait value
w2:
        loop    w2                      ;Waste time
        pop     cx                      ;Waste more?
        loop    w1                      ; yes: go do it
        ret                             ; no: go do something useful

delay           endp

;********************************************************************

msg     db      "Watch the keyboard LEDs... Press any key to stop."
        db      13,10,'$'
oldval  db      ?

        END     main
