MODEL TINY
org 100h
.386

; 386REG.ASM: Hooks timer INT 8 and provides a continuous display of
;             EAX, EBX, ECX, EDX, ESI, EDI on the top line of the screen.

;             Written by Rowan Crowe (3:635/727.1@fidonet)

;             Released to the Public Domain


DATASEG
   __nybtab: db '0123456789abcdef'
   __regmsg: db 'EAX=EBX=ECX=EDX=ESI=EDI=EBP='
   _end_of_code:

CODESEG
startupcode

        mov   es, cs:[002ch]
        mov   ah, 49h
        int   21h          ; free environment

        mov   ax, 3508h
        int   21h
        mov   cs:word ptr __oldint8, bx
        mov   cs:word ptr __oldint8+2, es

        mov   ax, 2508h
        mov   bx, cs
        mov   ds, bx
        mov   dx, offset _int8
        int   21h

        mov   ax, 3100h
        mov   dx, offset _end_of_code
        shr   dx, 4
        inc   dx
        int   21h

_int8 proc near
        call  _showreg
        db    0eah    ;
__oldint8:
        dw    ?       ; jmp far
        dw    ?       ;
endp

_showreg proc near
        push  gs fs es ds ebp edi esi edx ecx ebx eax
        mov   bp, sp
        mov   ax, 0b800h
        mov   es, ax
        mov   ax, cs
        mov   ds, ax
        xor   si, si      ; pointer to regs
        xor   di, di      ; screen write pointer
        mov   ah, 16h
        mov   al, ' '
        stosw
@L1:
        mov   bx, si
        add   bx, offset __regmsg
        mov   cx, 4
@L2:
        mov   al, [bx]
        inc   bx
        stosw
        loop  @L2

        mov   ebx, [bp+si]
        call  _hex32
        mov   al, ' '
        stosw
        add   si, 4
        cmp   si, 24
        jb    @L1
        pop   eax ebx ecx edx esi edi ebp ds es fs gs
        ret
endp

_hex32 proc near
; EBX = number to display
        push  ebx
        shr   ebx, 16
        call  _hex16
        pop   ebx
        call  _hex16
        ret
endp

_hex16 proc near
; BX = number to display
        xchg  bh, bl
        call  _hex8
        xchg  bh, bl
        call  _hex8
        ret
endp

_hex8 proc near
; BL = number to display

        push  bx
        push  bx
        shr   bl, 1
        shr   bl, 1
        shr   bl, 1
        shr   bl, 1
        call  _nybble
        pop   bx
        call  _nybble
        pop   bx
        ret
endp

_nybble proc near
        and   bx, 0fh
        mov   al, byte ptr __nybtab+bx
        stosw
        ret
endp
end
