;==============================================================================
; Shrink v1.0
;	Executable Shrinker by Craig Jackson
;------------------------------------------------------------------------------
; Assembler   : MASM 6.10
; Requirements: 8086, DOS 2.0

	.MODEL tiny
	.8086
	.DOSSEG

	; Executable file header structure
	EXEHEADER	STRUCT
		wSignature	WORD	?	;File signature
		wExtraBytes WORD	?	;Number of bytes in last page
		wPages		WORD	?	;Number of pages in file
		wRelocItems WORD	?	;Number of relocation items
		wHeaderSize WORD	?	;Size of header in paragraphs
		wMinAlloc	WORD	?	;Minimum allocation
		wMaxAlloc	WORD	?	;Maximum allocation
		wInitSS 	WORD	?	;Initial SS
		wInitSP 	WORD	?	;Initial SP
		wChecksum	WORD	?	;Complement checksum
		wInitIP 	WORD	?	;Initial IP
		wInitCS 	WORD	?	;Initial CS
		wRelocTable WORD	?	;Offset to relocation table
		wOverlay	WORD	?	;Overlay number
	EXEHEADER	ENDS

	EXEHEADER_PARAGRAPHS EQU 2	;Number of paragraphs to reserve for header
	PAGESIZE_BYTES		 EQU 512;Size of page in bytes
	PARAGRAPHSIZE_BYTES  EQU 16 ;Size of paragraph in bytes

	.STACK 0100h

	.DATA
	txtHeader	db	'SHRINK v1.0 - Executable Shrinker: ', 024h
	txtDone 	db	'Done', 024h
	txtError	db	'Fatal error', 007h, 024h

	wDivisor16	dw	PARAGRAPHSIZE_BYTES ;Paragraph size in bytes
	wDivisor512 dw	PAGESIZE_BYTES		;Page size in bytes

	.DATA?
	hdrExecutable EXEHEADER <?> 			;Buffer for executable header
	bufFilePage db	PAGESIZE_BYTES dup (?)	;Buffer for executable page

	.CODE
	.STARTUP
	; Display header
	mov 	ah,009h 					;Output string
	mov 	dx,OFFSET txtHeader 		;DX = Offset of string
	int 	021h						;	Interrupt: DOS

	; Determine old executable filename
	mov 	dx,05Dh 					;DX = Offset to executable filename
	mov 	di,dx						;DI = Offset of filename search buffer
	mov 	cx,00008h					;CX = Characters in filename root
	mov 	al,020h 					;AL = Space
	repne	scasb						;Find end of filename root
	mov 	ax,'O.'                     ;AX = '.','O'
	stosw								;Store '.','O'
	mov 	ax,'DL'                     ;AX = 'L','D'
	stosw								;Store 'L','D'
	mov 	BYTE PTR [di],000h			;Store NULL

	; Determine executable filename
	sub 	cl,008h 					;
	neg 	cl							;CX = Length of filename root
	mov 	si,dx						;SI = Offset of filename in PSP
	mov 	di,06Dh 					;DI = Offset of rename filename buffer
	push	di							;Preserve DI
	rep 	movsb						;Copy filename root
	mov 	ax,'E.'                     ;AX = '.','E'
	stosw								;Store '.','E'
	mov 	al,'X'                      ;AX = 'X','E'
	stosw								;Store 'X,'E'
	mov 	BYTE PTR [di],000h			;Store NULL
	pop 	di							;Restore DI

	; Delete old executable file
	mov 	ah,041h 					;Delete file
	int 	021h						;	Interrupt: DOS

	; Rename executable file to old executable file
	mov 	ah,056h 					;Rename file
	xchg	dx,di						;DX = Executable, DI = Old executable
	int 	021h						;	Interrupt: DOS
	jc		exiterrorshorta 			;	Jump: Error renaming file
	push	dx							;Preserve output filename
	mov 	dx,di						;DX = Offset of old executable filename

	; Open old executable file
	mov 	ax,03D00h					;Open file for reading (handle)
	int 	021h						;	Interrupt: DOS
	jc		exiterrorshorta 			;	Jump: Error opening file
	mov 	bx,ax						;BX = Handle of executable file

	; Read executable header
	mov 	ah,03Fh 					;Read file (handle)
	mov 	cl,SIZEOF(EXEHEADER)		;CX = Number of bytes to read
	mov 	dx,OFFSET hdrExecutable 	;DX = Offset of header buffer
	mov 	di,dx						;DI = Offset of header buffer
	int 	021h						;	Interrupt: DOS
	jc		exiterrorshorta 			;	Jump: Error reading file

	; Check executable signature
	cmp 	[di].EXEHEADER.wSignature,'ZM';Check executable signature
	je		@F							;
exiterrorshorta:
	jmp 	exiterror					;	Jump: Error with file signature
@@:

	; Create shrunken executable
	mov 	ah,03Ch 					;Create or truncate file (handle)
	xor 	cx,cx						;CX = Normal file attribute
	pop 	dx							;DX = Offset of output filename
	int 	021h						;	Interrupt: DOS
	jc		exiterrorshorta 			;	Jump: Error creating file
	mov 	bp,ax						;BP = Output file

	; Generate shrunken executable header
	mov 	ax,[di].EXEHEADER.wRelocItems ;AX = Number of relocation entries
	shl 	ax,1						;
	shl 	ax,1						;AX = Number of entries * SIZEOF(DWORD)
	add 	ax,SIZEOF(EXEHEADER)		;AX = SIZEOF(EXEHEADER) + SIZEOF(relocs)
	mov 	cx,ax						;CX = SIZEOF(EXEHEADER) + SIZEOF(relocs)
	xor 	dx,dx						;DX:AX = SIZEOF(EXEHEADER) + SIZEOF(relocs)
	mov 	si,OFFSET wDivisor16		;SI = Offset of paragraph divisor
	div 	WORD PTR [si]				;DX = opposite pad value, AX = header size in paragraphs
	sub 	[si],dx 					;wDivisor16 = pad value
	add 	cx,[si] 					;CX = SIZEOFF(HEADER_PADDED)
	inc 	ax							;Update header paragraph count
	or		dx,dx						;Check for no padding
	jnz 	@F							;	Jump: Padding enabled
	sub 	cx,[si] 					;CX = SIZEOFF(HEADER_PADDED)
	dec 	ax							;Retreat header paragraph count
	mov 	BYTE PTR [si],000h			;Clear padding width
@@: mov 	si,[di].EXEHEADER.wHeaderSize ; Store original header size
	mov 	[di].EXEHEADER.wHeaderSize,ax ;Store new header size

	push	cx							;Preserve CX
	mov 	ax,04202h					;Seek file from end (handle)
	xor 	cx,cx						;CX = High word of offset
	xor 	dx,dx						;DX = Low word of offset
	int 	021h						;	Interrupt: DOS
	pop 	cx							;Restore CX

	add 	ax,cx						;
	adc 	dx,00000h					;DX:AX = Filesize + headersize

	mov 	cl,004h 					;CL = Paragraph shift count
	shl 	si,cl						;SI = Old headersize in bytes
	sub 	ax,si						;
	sbb 	dx,00000h					;DX:AX = Headersize + (filesize - oldheadersize)
	div 	wDivisor512 				;DX = size of last page, AX = pages-1
	inc 	ax							;AX = pages
	mov 	[di].EXEHEADER.wExtraBytes,dx ;Store size of last page
	mov 	[di].EXEHEADER.wPages,ax	;Store total pages

	push	[di].EXEHEADER.wRelocTable	;Preserve original relocation table offset
	mov 	[di].EXEHEADER.wRelocTable,SIZEOF(EXEHEADER) ;wRelocTable adjusted

	; Write shrunken executable header
	mov 	ah,040h 					;Write to file (handle)
	xchg	bx,bp						;BX = Output file, BP = Executable file
	mov 	cl,SIZEOF(EXEHEADER)		;CX = Number of bytes to write (CH = 0)
	mov 	dx,di						;DX = Offset of executable header
	int 	021h						;	Interrupt: DOS
	jc		exiterrorshortb 			;	Jump: Error writing file

	; Transfer relocation table
	mov 	ax,04200h					;Seek file from beginning (handle)
	xchg	bx,bp						;BX = Executable file, BP = Output file
	xor 	cx,cx						;CX = High word of file offset
	pop 	dx							;DX = Original relocation table offset
	int 	021h						;	Interrupt: DOS
exiterrorshortb:
	jc		exiterror					;	Jump: Error seeking file

	mov 	dx,OFFSET bufFilePage		;DX = Relocation entry transfer buffer
	mov 	cl,SIZEOF(DWORD)			;CX = Size of relocation entry
loopTransferRelocItems:
	sub 	[di].EXEHEADER.wRelocItems,1;Decrement loop counter
	jc		doneTransferRelocItems		;	Jump: Relocation entries transfered

	mov 	ah,03Fh 					;Read from file (handle)
	int 	021h						;	Interrupt: DOS
	jc		exiterror					;	Jump: Error reading file

	mov 	ah,040h 					;Write to file (handle)
	xchg	bx,bp						;BX = Output file, BP = Executable file
	int 	021h						;	Interrupt: DOS
	jc		exiterror					;	Jump: Error writing file

	xchg	bx,bp						;BX = Executable file, BP = Output file

	jmp 	loopTransferRelocItems		;	Jump: Transfer next relocation entry
doneTransferRelocItems:

	; Align to nearest paragraph
	mov 	ah,040h 					;Write to file (handle)
	xchg	bx,bp						;BX = Output file, BP = Executable file
	mov 	cx,wDivisor16				;CX = Padding width
	mov 	dx,OFFSET txtHeader 		;DX = Offset of program header (signature < 16chars)
	int 	021h						;	Interrupt: DOS
	jc		exiterror					;	Jump: Error writing file

	; Remove oldheader size from page count
	mov 	ax,[di].EXEHEADER.wPages	;AX = Number of pages
	dec 	ax							;AX = Number of full pages
	mul 	wDivisor512 				;DX:AX = Number of full pages * SIZEOF(PAGE)
	add 	ax,[di].EXEHEADER.wExtraBytes ;
	adc 	dx,00000h					;DX:AX = Filesize in bytes

	push	ax							;Preserve AX
	mov 	ax,[di].EXEHEADER.wHeaderSize ;AX = Paragraphs in header and relocations
	mov 	cl,004h 					;CL = Paragraph shift count
	shl 	ax,cl						;AX = Bytes in header and relocation
	mov 	cx,ax						;CX = Bytes in header and relocation
	pop 	ax							;Restore AX

	sub 	ax,cx						;
	sbb 	dx,00000h					;DX:AX = Filesize in bytes - header bytes
	div 	wDivisor512 				;DX = Bytes in last page, AX = Pages-1
	mov 	[di].EXEHEADER.wPages,ax	;Store pages-1 counter
	mov 	[di].EXEHEADER.wExtraBytes,dx ;Store bytes counter

	; Transfer main executable section
	mov 	ax,04200h					;Seek file from beginning (handle)
	xchg	bx,bp						;BX = Executable file, BP = Output file
	xor 	cx,cx						;CX = High word of file offset
	mov 	dx,si						;DX = Original header size in bytes
	int 	021h						;	Interrupt: DOS
	jc		exiterror					;	Jump: Error seeking file

	mov 	dx,OFFSET bufFilePage		;DX = File page transfer buffer
	mov 	cx,PAGESIZE_BYTES			;CX = Size of page
	mov 	si,[di].EXEHEADER.wPages	;SI = Number of pages
loopTransferMain:
	or		si,si						;Check for last page
	jnz 	@F							;	Jump: Earlier page
	mov 	cx,[di].EXEHEADER.wExtraBytes ;CX = Size of last page
@@: mov 	ah,03Fh 					;Read file (handle)
	int 	021h						;	Interrupt: DOS
	jc		exiterror					;	Jump: Error reading main section

	mov 	ah,040h 					;Write to file (handle)
	xchg	bx,bp						;BX = Output file, BP = Executable file
	int 	021h						;	Interrupt: DOS
	jc		exiterror					;	Jump: Error writing main section

	xchg	bx,bp						;BX = Executable file, BP = Output file

	sub    si,1 						;Decrement loop counter
	jnc    loopTransferMain 			;	Jump: Transfer next page

	; Close executable file
	mov 	ah,03Eh 					;Close file (handle)
	int 	021h						;	Interrupt: DOS

	; Close output file
	mov 	bx,bp						;BX = Handle of executable file
	int 	021h						;	Interrupt: DOS

	; Terminate program
	mov 	dx,OFFSET txtDone			;DX = Offset of string
exit:
	mov 	ah,009h 					;Output string
	int 	021h						;	Interrupt: DOS
	.EXIT

	; Terminate program with vague error message
exiterror:
	mov 	dx,OFFSET txtError			;DX = Offset of string
	jmp 	exit						;	Jump: Terminate program with message

	END
