;-----------------------------------------
;  From: Bill Moyer
;  Subj: Re: 320x200X256 graphics
 
  Well, I have a little algorithm for putting an image on the screen
in 320x200x256 mode, and its performance is limited by RAM access speed,
not CPU speed, on every computer system I've tested it on so far.  So
even if it could be optimized further it wouldn't be any faster..
 
UNIT FastGraf;
  Interface
 
  { PutImageF is a procedure meant to replace Borland's   }
  { original PutImage procedure.  By recoding the routine }
  { in assembly, I hope to have improved the performance  }
  { of the operation somewhat.  Note that this procedure  }
  { was fashioned specifically for 320x200x256 mode, and  }
  { will not work properly for any other mode.  X and Y   }
  { in the parameter list indicate where the image stored }
  { at the location pointed to by This will be placed.    }
  { The expected format of this data is the same as that  }
  { generated by Borland's GetImage procedure.            }
 
  Procedure PutImageF ( X, Y : Integer;  This : Pointer );
 
  Implementation
 
  Type VPtr = Array[1..2] of Integer;
 
  Procedure PutImageF ( X, Y : Integer;  This : Pointer );
    Var Foo, Bar : Integer;
    Begin
      Foo := VPtr(This)[1];  Bar := VPtr(This)[2];    { clock cycles }
      asm                                               { on 80386 }
      mov  ax, Y          { y-coordinate }                 {  4 }
      mov  cx, X          { x-coordinate }                 {  4 }
      mov  bx, ax         { preparation for mul by 320 }   {  2 }
      shl  ax, 2          { have now mul ax,   4 }         {  3 }
      add  ax, bx         { have now mul ax,   5 }         {  2 }
      shl  ax, 6          { have now mul ax, 320 }         {  7 }
      add  ax, cx         { ax now points to destination } {  2 }
      mov  di, ax         { store that in di }             {  2 }
      mov  dx, ds         { dx holds old ds }              {  2 }
      mov  ax, Bar                                         {  4 }
      mov  bx, Foo        { bx indexes start of source }   {  4 }
      mov  ds, ax         { ds is source segment }         {  2 }
      mov  ax, $a000      { location of dos vga buffer }   {  2 }
      mov  es, ax         { es is destination segment }    {  2 }
      mov  si, bx         { si indexes source segment }    {  2 }
      mov  cx, ds:[bx]    { cx holds width  }              {  4 }
      mov  bx, ds:[bx+2]  { bx holds height }              {  4 }
      add  si, 4          { data begins after 6th byte }   {  3 }
      mov  ax, cx         { keep copy of cx in ax }        {  2 }
      @movingstuff:       { here we go! }
      rep movsb           { moving from si to di }      { 5+(4*cx) }
      mov  cx, ax         { restoring cx }                 {  2 }
      sub  di, cx         { moving di to next spot }       {  3 }
      add  di, 320        { di points to next "row" }      {  3 }
      dec  bx             { decrementing the row counter } {  2 }
      jnz @movingstuff    { if not last row do it again } { 14/3 }
      mov  ds, dx         { restoring data segment }       {  2 }
      End; End;
  End.  { of unit }
 
