@echo off

rem JAM R1.20, CHKALL.BAT -- checks all existing JAM drives
rem Sun Oct 9 1994, written by George A. Reznik.
rem Copyright (c) 1992-1994 JAM Software.
rem All Rights Reserved.

goto entry

:usage
echo Checks all existing JAM drives.
echo Use:
echo 	CHKALL [/?] [/Q ! /V] [/F] [D1: D2: ...]
echo Where:
echo    /Q	Quiet mode
echo    /V	Verbose displays of file names encountered
echo    /F	Fixes errors on disk(s)
goto end

:addopt2
set nomsg=1
if "%nomsg%" == "" goto end

:addopt
if not "%chkopt%" == "" goto add
set chkopt=/V/F/C/E/T/X/N/A
if "%chkopt%" == "" goto end
set chkopt=

:add
set chkopt=%chkopt%%1

:next
shift

:entry
if "%1" == "" chkall A: B: C: D: E: F: G: H: I: J: K: L: M: N: O: P: Q: R: S: T: U: V: W: X: Y: Z:

for %%o in (Q q) do if /%%o == %1 goto addopt2
for %%o in (V F C E T N A v f c e t n a) do if /%%o == %1 goto addopt

if not "%nomsg%" == "" goto ishlp

echo CHKALL 1.20  Copyright (c) JAM Software, 1992-1994. All rights reserved.
echo:

set nomsg=1
if "%nomsg%" == "" goto end

:ishlp
if "%1" == "/?" goto usage
if "%1" == "/H" goto usage
if "%1" == "/h" goto usage

for %%d in (A B C D E F G H I J K L M N O P Q R S T U V W X Y Z) do if %%d: == %1 goto chkcmd
for %%d in (a b c d e f g h i j k l m n o p q r s t u v w x y z) do if %%d: == %1 goto chkcmd

echo Invalid parameter: %1 !!!
goto end

:chkcmd
if not exist chkdrv.bat goto build
if exist jam.bat goto run

:build
echo Building secondary command file ...

echo if "%%4" == "available" goto end	>  jam.bat
echo if "%%5" == "[Locked]" goto end	>> jam.bat
echo jchkdsk %%2 %chkopt%		>> jam.bat
echo if not errorlevel 1 goto end	>> jam.bat
echo pause				>> jam.bat
echo :end				>> jam.bat
if not exist jam.bat goto cerror

:run
echo Analyzing drive %1 ... 

jmount /q %1 > chkdrv.bat
if errorlevel 2 goto end
if errorlevel 1 goto next
if not exist chkdrv.bat goto cerror

call chkdrv.bat
goto next

:cerror
echo Cannot create a file on current drive.

:end
if exist chkdrv.bat del chkdrv.bat
if exist jam.bat del jam.bat
if not "%chkopt%" == "" set chkopt=
if not "%nomsg%" == "" set nomsg=

